@extends('landingpage::layouts.admin')

@section('title', 'Create New Landing Page')

@push('module_styles')
{{-- Add any page-specific Tailwind-compatible styles here if absolutely necessary --}}
@endpush

@section('module_content')
<div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">
    <div class="sm:flex sm:justify-between sm:items-center mb-8">
        <h1 class="text-2xl md:text-3xl text-slate-800 dark:text-slate-100 font-bold">Create New Landing Page</h1>
    </div>

    <nav class="mb-6 text-sm" aria-label="Breadcrumb">
        <ol class="list-none p-0 inline-flex">
            <li class="flex items-center">
                <a href="{{ route('admin.dashboard') }}" class="text-blue-500 hover:text-blue-700 hover:underline dark:text-blue-400 dark:hover:text-blue-300">Dashboard</a>
                <svg class="fill-current w-3 h-3 mx-3 text-slate-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"/></svg>
            </li>
            <li class="flex items-center">
                <a href="{{ route('admin.landingpage.pages.index') }}" class="text-blue-500 hover:text-blue-700 hover:underline dark:text-blue-400 dark:hover:text-blue-300">Manage Pages</a>
                <svg class="fill-current w-3 h-3 mx-3 text-slate-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"/></svg>
            </li>
            <li class="flex items-center">
                <span class="text-slate-500 dark:text-slate-400">Create Page</span>
            </li>
        </ol>
    </nav>

    <form action="{{ route('admin.landingpage.pages.store') }}" method="POST">
        @csrf

        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Page Details</h3>
            </div>
            <div class="p-6">
                <div class="mb-4">
                    <label for="title" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Title <span class="text-red-500">*</span></label>
                    <input type="text" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('title') border-red-500 @enderror" id="title" name="title" value="{{ old('title') }}" required>
                    @error('title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div class="mb-4">
                    <label for="slug" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Slug (auto-generated if blank)</label>
                    <input type="text" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('slug') border-red-500 @enderror" id="slug" name="slug" value="{{ old('slug') }}">
                    @error('slug') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div class="mb-4">
                    <label for="main_content_editor" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Main Content (Fallback/Default)</label>
                    <textarea class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('content') border-red-500 @enderror" id="main_content_editor" name="content" rows="10">{{ old('content') }}</textarea>
                    @error('content') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">SEO Settings</h3>
            </div>
            <div class="p-6">
                <div class="mb-4">
                    <label for="meta_title" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Meta Title</label>
                    <input type="text" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" id="meta_title" name="meta_title" value="{{ old('meta_title') }}">
                </div>
                <div class="mb-4">
                    <label for="meta_description" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Meta Description</label>
                    <textarea class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" id="meta_description" name="meta_description" rows="3">{{ old('meta_description') }}</textarea>
                </div>
                <div class="mb-4">
                    <label for="meta_keywords" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Meta Keywords (comma-separated)</label>
                    <input type="text" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords') }}">
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Page Settings</h3>
            </div>
            <div class="p-6">
                <div class="mb-4">
                    <label for="theme_template" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Theme Template</label>
                    <select id="theme_template" name="theme_template" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                        @foreach($themeTemplates as $value => $label)
                            <option value="{{ $value }}" {{ old('theme_template') == $value ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Select a page template from your active theme. Leave as 'Default' for standard rendering.</p>
                </div>
                <div class="mb-4">
                    <label for="sort_order" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Sort Order</label>
                    <input type="number" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" id="sort_order" name="sort_order" value="{{ old('sort_order', 0) }}">
                </div>
                <div class="flex items-center mb-4">
                    <input id="is_published" name="is_published" type="checkbox" value="1" class="h-4 w-4 text-blue-600 border-slate-300 dark:border-slate-600 rounded focus:ring-blue-500 dark:bg-slate-700 dark:focus:ring-blue-600 dark:ring-offset-slate-800" {{ old('is_published', true) ? 'checked' : '' }}>
                    <label for="is_published" class="ml-2 block text-sm text-slate-900 dark:text-slate-300">Published</label>
                </div>
            </div>
        </div>

        {{-- Note: Sections are typically added/managed after page creation via the Edit Page screen.
             If you need to add sections during creation, this form would need to be more complex,
             potentially using Livewire or more advanced JavaScript to handle dynamic section additions
             before the page ID exists. For simplicity, we'll keep section management on the edit page. --}}

        <div class="flex justify-end space-x-3">
            <a href="{{ route('admin.landingpage.pages.index') }}" class="px-4 py-2 border border-slate-300 dark:border-slate-600 rounded-md text-sm font-medium text-slate-700 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-slate-900">Cancel</a>
            <button type="submit" class="inline-flex items-center px-6 py-3 bg-blue-600 border border-transparent rounded-md font-semibold text-sm text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-800 focus:outline-none focus:border-blue-900 focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 disabled:opacity-50 transition ease-in-out duration-150">Create Page</button>
        </div>
    </form>
</div>
@endsection

@push('module_scripts')
{{-- Include TinyMCE from CDN --}}
<script src="https://cdn.tiny.cloud/1/{{ setting('tinymce_api_key', 'YOUR_FALLBACK_TINYMCE_API_KEY_OR_LEAVE_EMPTY') }}/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Basic slug generation from title if slug field is empty
    const titleInput = document.getElementById('title');
    const slugInput = document.getElementById('slug');

    if (titleInput && slugInput) {
        titleInput.addEventListener('keyup', function() {
            if (slugInput.value === '' || slugInput.dataset.generated === 'true') {
                slugInput.value = generateSlug(this.value);
                slugInput.dataset.generated = 'true';
            }
        });

        slugInput.addEventListener('keyup', function() {
            // If user types in slug field, stop auto-generation
            slugInput.dataset.generated = 'false';
        });
    }

    function generateSlug(text) {
        return text.toString().toLowerCase()
            .replace(/\s+/g, '-')           // Replace spaces with -
            .replace(/[^\w\-]+/g, '')       // Remove all non-word chars
            .replace(/\-\-+/g, '-')         // Replace multiple - with single -
            .replace(/^-+/, '')             // Trim - from start of text
            .replace(/-+$/, '');            // Trim - from end of text
    }

    // Initialize TinyMCE for the main content editor
    if (document.getElementById('main_content_editor')) {
        tinymce.init({
            selector: '#main_content_editor',
            plugins: 'advlist autolink lists link image charmap print preview anchor searchreplace visualblocks code fullscreen insertdatetime media table paste code help wordcount',
            toolbar: 'undo redo | formatselect | bold italic backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help | code',
            height: 400, // You can adjust the height
            setup: function (editor) {
                editor.on('change', function () {
                    editor.save(); // Important for AJAX submissions or if you need to trigger updates
                });
            }
        });
    }
});
</script>
@endpush