{{-- 
    $item: The current menu item to render as an option
    $currentParentId: The parent_id of the item being added/edited (for selecting the current parent)
    $itemIdToExclude: The ID of the item being edited (to prevent self-parenting)
    $indent: Indentation string (e.g., '&nbsp;&nbsp;')
--}}
@if(!isset($itemIdToExclude) || $item->id != $itemIdToExclude)
    <option value="{{ $item->id }}" {{ (isset($currentParentId) && $currentParentId == $item->id) ? 'selected' : '' }}>
        {!! $indent !!}{{ $item->title }}
    </option>
    @foreach($item->children as $child)
        @include('landingpage::admin.menus.partials.menu-item-option', ['item' => $child, 'currentParentId' => $currentParentId ?? null, 'itemIdToExclude' => $itemIdToExclude ?? null, 'indent' => ($indent ?? '') . '&nbsp;&nbsp;&nbsp;&nbsp;'])
    @endforeach
@endif