{{--
    $optionItem: The menu item to display as an option.
    $itemIdToExclude: The ID of the item being edited (and its children) to exclude.
    $currentParentId: The current parent_id of the item being edited, for pre-selection.
    $indent: String for indentation.
--}}

@php
    // Basic check to exclude the item itself. A more robust check for descendants would be needed
    // if you want to prevent moving an item under its own child directly in this dropdown.
    // The JavaScript part of the modal now handles descendant exclusion.
    if (isset($itemIdToExclude) && $optionItem->id == $itemIdToExclude) {
        // Skip this item
        return;
    }
@endphp

<option value="{{ $optionItem->id }}" {{ (isset($currentParentId) && $currentParentId == $optionItem->id) ? 'selected' : '' }}>
    {!! $indent !!}{{ $optionItem->title }}
</option>

@if ($optionItem->children && $optionItem->children->isNotEmpty())
    @foreach ($optionItem->children as $child)
        @include('landingpage::admin.menus.partials.menu-item-option-for-edit', [
            'optionItem' => $child,
            'itemIdToExclude' => $itemIdToExclude,
            'currentParentId' => $currentParentId,
            'indent' => $indent . '&nbsp;&nbsp;&nbsp;&nbsp;'
        ])
    @endforeach
@endif
