{{--
    $item: The current menu item to render as an option
    $currentParentId: The parent_id from old input (for selecting the current parent)
    $indent: Indentation string (e.g., '&nbsp;&nbsp;')
--}}
<option value="{{ $item->id }}" {{ (isset($currentParentId) && $currentParentId == $item->id) ? 'selected' : '' }}>
    {!! $indent !!}{{ $item->title }}
</option>
@if ($item->children->isNotEmpty())
    @foreach($item->children as $child)
        @include('landingpage::admin.menus.partials.menu-item-option-for-add', [
            'item' => $child,
            'currentParentId' => $currentParentId ?? null,
            'indent' => ($indent ?? '') . '&nbsp;&nbsp;&nbsp;&nbsp;'
        ])
    @endforeach
@endif