{{--
    $item: The current MenuItem instance.
    $menu: The parent Menu instance.
    $availablePages: Array of pages for the select dropdown in the modal.
    $level: (Optional) Current depth level for indentation, defaults to 0. Passed by parent.
--}}
@php
    $currentLevel = $level ?? 0;
    $indentationClass = 'ml-' . ($currentLevel * 6); // Tailwind CSS for indentation (ml-0, ml-6, ml-12, etc.)
@endphp

<li class="menu-item-draggable {{ $indentationClass }} bg-slate-100 dark:bg-slate-700 p-3 rounded-md shadow-sm"
    data-id="{{ $item->id }}"
    x-data="{
        editModalOpen: false,
        itemToEdit: {
            id: {{ $item->id }},
            title: '{{ addslashes($item->title) }}',
            type: '{{ $item->type }}',
            lp_page_id: '{{ $item->lp_page_id ?? '' }}',
            url: '{{ $item->url ?? '' }}',
            route_name: '{{ $item->route_name ?? '' }}',
            target: '{{ $item->target ?? '_self' }}',
            icon_class: '{{ $item->icon_class ?? '' }}',
            css_class: '{{ $item->css_class ?? '' }}',
            parent_id: '{{ $item->parent_id ?? '' }}'
        }
    }">
    <div class="flex justify-between items-center">
        <div class="flex items-center">
            <span class="drag-handle cursor-grab text-slate-400 dark:text-slate-500 hover:text-slate-600 dark:hover:text-slate-300 mr-3">
                <i class="fas fa-grip-vertical"></i>
            </span>
            <span class="font-medium text-slate-800 dark:text-slate-100">
                @if($item->icon_class)<i class="{{ $item->icon_class }} mr-2"></i>@endif
                {{ $item->title }}
            </span>
            <span class="text-xs text-slate-500 dark:text-slate-400 ml-2">
                ({{ $item->link }}) {{-- Assuming 'link' is an accessor on MenuItem model --}}
            </span>
        </div>
        <div class="flex items-center space-x-2">
            <button @click="editModalOpen = true" type="button" class="text-blue-500 hover:text-blue-700 dark:text-blue-400 dark:hover:text-blue-300 text-sm" title="Edit Item"><i class="fas fa-edit"></i></button>

            {{-- Delete Button --}}
            <form action="{{ route('admin.landingpage.menus.items.destroy', ['menu' => $menu->id, 'item' => $item->id]) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this menu item and all its children?');" class="inline-block">
                @csrf
                @method('DELETE')
                <button type="submit" class="text-red-500 hover:text-red-700 dark:text-red-400 dark:hover:text-red-300 text-sm" title="Delete Item">
                    <i class="fas fa-trash-alt"></i>
                </button>
            </form>
        </div>
    </div>

    <!-- Edit Modal -->
    <div x-show="editModalOpen"
         class="fixed inset-0 bg-slate-900 bg-opacity-30 z-50 transition-opacity"
         aria-hidden="true"
         @click="editModalOpen = false"
         style="display: none;"></div>
    <div x-show="editModalOpen"
         class="fixed inset-0 z-[51] overflow-hidden flex items-center justify-center transform px-4 sm:px-6"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95"
         x-transition:enter-end="opacity-100 scale-100"
         x-transition:leave="transition ease-in duration-200"
         x-transition:leave-start="opacity-100 scale-100"
         x-transition:leave-end="opacity-0 scale-95"
         style="display: none;">
        <div class="bg-white dark:bg-slate-800 rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-[90vh]" @click.outside="editModalOpen = false">
            <form :action="'{{ route('admin.landingpage.menus.index') }}/{{ $menu->id }}/items/' + itemToEdit.id" method="POST">
                @csrf
                @method('PUT')
                <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                    <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Edit Menu Item: <span x-text="itemToEdit.title"></span></h3>
                </div>
                <div class="p-6 space-y-4 max-h-[calc(90vh-120px)] overflow-y-auto">
                    <div>
                        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Title <span class="text-red-500">*</span></label>
                        <input type="text" name="title" x-model="itemToEdit.title" required class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Link Type <span class="text-red-500">*</span></label>
                        <select name="type" required x-model="itemToEdit.type" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                            <option value="page">Page Link</option>
                            <option value="url">Custom URL</option>
                            <option value="route">Named Route</option>
                        </select>
                    </div>
                    <div x-show="itemToEdit.type === 'page'">
                        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Select Page <span class="text-red-500">*</span></label>
                        <select name="lp_page_id" x-model="itemToEdit.lp_page_id" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                            <option value="">-- Select a Page --</option>
                            @foreach($availablePages as $id => $pageTitle)
                                <option value="{{ $id }}">{{ $pageTitle }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div x-show="itemToEdit.type === 'url'">
                        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Custom URL <span class="text-red-500">*</span></label>
                        <input type="url" name="url" x-model="itemToEdit.url" placeholder="https://example.com" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                    </div>
                    <div x-show="itemToEdit.type === 'route'">
                        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Route Name <span class="text-red-500">*</span></label>
                        <input type="text" name="route_name" x-model="itemToEdit.route_name" placeholder="e.g., frontend.contact" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                    </div>
                     <div>
                        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Target</label>
                        <select name="target" x-model="itemToEdit.target" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                            <option value="_self">Same Window (_self)</option>
                            <option value="_blank">New Window (_blank)</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Icon Class (Optional)</label>
                        <input type="text" name="icon_class" x-model="itemToEdit.icon_class" placeholder="e.g., fas fa-home" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Custom CSS Class (Optional)</label>
                        <input type="text" name="css_class" x-model="itemToEdit.css_class" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                    </div>
                    {{-- Parent ID selection in modal is complex due to potential recursion and avoiding self-parenting.
                         For now, parent changes might be better handled by drag-and-drop or a dedicated UI.
                         If you need to edit parent_id here, you'd populate a select dropdown similar to the "Add New Item" form,
                         excluding the current itemToEdit.id and its descendants.
                    <input type="hidden" name="parent_id" :value="itemToEdit.parent_id"> --}}
                </div>
                <div class="px-6 py-4 bg-slate-50 dark:bg-slate-700 border-t border-slate-200 dark:border-slate-600 flex justify-end space-x-3">
                    <button type="button" @click="editModalOpen = false" class="px-4 py-2 border border-slate-300 dark:border-slate-600 rounded-md text-sm font-medium text-slate-700 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-700">Cancel</button>
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-800">Save Changes</button>
                </div>
            </form>
        </div>
    </div>

    {{-- Recursively include children --}}
    @if ($item->children->isNotEmpty())
        <ul class="ml-6 mt-2 space-y-2 nested-menu-items-list"> {{-- Added class for JS targeting if needed by SortableJS --}}
            @foreach ($item->children as $child)
                @include('landingpage::admin.menus.partials.menu-item-display', ['item' => $child, 'menu' => $menu, 'availablePages' => $availablePages, 'level' => $currentLevel + 1])
            @endforeach
        </ul>
    @endif
</li>
