{{-- d:\projects\digitalvocano\Modules\LandingPage\resources\views\admin\menus\edit.blade.php --}}
@extends('landingpage::layouts.admin')

@section('title', 'Edit Menu - ' . $menu->name)

@push('module_styles')
@endpush

@section('module_content')
<div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">
    <div class="sm:flex sm:justify-between sm:items-center mb-8">
        <h1 class="text-2xl md:text-3xl text-slate-800 dark:text-slate-100 font-bold">Edit Menu: {{ $menu->name }}</h1>
    </div>

    <nav class="mb-6 text-sm" aria-label="Breadcrumb">
        <ol class="list-none p-0 inline-flex">
            <li class="flex items-center">
                <a href="{{ route('admin.dashboard') }}" class="text-blue-500 hover:text-blue-700 hover:underline dark:text-blue-400 dark:hover:text-blue-300">Dashboard</a>
                <svg class="fill-current w-3 h-3 mx-3 text-slate-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373 9.373 24.569 9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"/></svg>
            </li>
            <li class="flex items-center">
                <a href="{{ route('admin.landingpage.menus.index') }}" class="text-blue-500 hover:text-blue-700 hover:underline dark:text-blue-400 dark:hover:text-blue-300">Menus</a>
                <svg class="fill-current w-3 h-3 mx-3 text-slate-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373 9.373 24.569 9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"/></svg>
            </li>
            <li class="flex items-center">
                <span class="text-slate-500 dark:text-slate-400">Edit Menu</span>
            </li>
        </ol>
    </nav>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border-l-4 border-green-400 text-green-700 dark:bg-green-900 dark:text-green-300 dark:border-green-600 rounded-md relative" role="alert">
            <strong class="font-bold">Success!</strong> {{ session('success') }}
            <button type="button" class="absolute top-0 bottom-0 right-0 px-4 py-3 text-green-700 dark:text-green-300 hover:text-green-900 dark:hover:text-green-100" onclick="this.parentElement.style.display='none';"><span>&times;</span></button>
        </div>
    @endif

    {{-- Menu Details Form --}}
    <form action="{{ route('admin.landingpage.menus.update', $menu->id) }}" method="POST" class="mb-8">
        @csrf
        @method('PUT')
        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Menu Details</h3>
            </div>
            <div class="p-6 space-y-6">
                <div>
                    <label for="name" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Menu Name <span class="text-red-500">*</span></label>
                    <input type="text" id="name" name="name" value="{{ old('name', $menu->name) }}" required
                           class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('name') border-red-500 @enderror">
                    @error('name') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="location" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Location (Optional)</label>
                    <select id="location" name="location"
                            class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('location') border-red-500 @enderror">
                        <option value="">-- No Specific Location --</option>
                        @foreach($menuLocations as $key => $label)
                            <option value="{{ $key }}" {{ old('location', $menu->location) == $key ? 'selected' : '' }}>
                                {{ $label }}
                            </option>
                        @endforeach
                    </select>
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Select a predefined location for theme integration, or leave blank.</p>
                    @error('location') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>
            <div class="px-6 py-4 bg-slate-50 dark:bg-slate-700 border-t border-slate-200 dark:border-slate-600 flex justify-end space-x-3">
                <a href="{{ route('admin.landingpage.menus.index') }}" class="px-4 py-2 border border-slate-300 dark:border-slate-600 rounded-md text-sm font-medium text-slate-700 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-slate-900">Cancel</a>
                <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-800 focus:outline-none focus:border-blue-900 focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 disabled:opacity-50 transition ease-in-out duration-150">Update Menu Details</button>
            </div>
        </div>
    </form>

    {{-- Menu Items Management --}}
    <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg">
        <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
            <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Menu Items for "{{ $menu->name }}"</h3>
        </div>
        <div class="p-6">
            {{-- Display Existing Menu Items (Recursive Partial) --}}
            <div class="mb-6">
                <h4 class="text-md font-semibold text-slate-700 dark:text-slate-200 mb-3">Current Items:</h4>
                @if($menu->rootItems->isEmpty())
                    <p class="text-slate-500 dark:text-slate-400">No items in this menu yet.</p>
                @else
                    <ul id="menu-items-list" class="space-y-2" data-menu-id="{{ $menu->id }}">
                        @foreach ($menu->rootItems as $item)
                            @include('landingpage::admin.menus.partials.menu-item-display', ['item' => $item, 'menu' => $menu, 'availablePages' => $availablePages])
                        @endforeach
                    </ul>
                @endif
            </div>

            <hr class="my-6 border-slate-200 dark:border-slate-700">

            {{-- Add New Menu Item Form --}}
            <div>
                <h4 class="text-md font-semibold text-slate-700 dark:text-slate-200 mb-3">Add New Item</h4>
                <form action="{{ route('admin.landingpage.menus.items.store', $menu->id) }}" method="POST">
                    @csrf
                    <div class="space-y-4" x-data="{ type: '{{ old('type', 'page') }}' }">
                        <div>
                            <label for="item_title" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Title <span class="text-red-500">*</span></label>
                            <input type="text" id="item_title" name="title" value="{{ old('title') }}" required
                                   class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('title') border-red-500 @enderror">
                            @error('title') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label for="item_type" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Link Type <span class="text-red-500">*</span></label>
                            <select id="item_type" name="type" required x-model="type"
                                    class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('type') border-red-500 @enderror">
                                <option value="page">Page Link</option>
                                <option value="url">Custom URL</option>
                                <option value="route">Named Route</option>
                            </select>
                            @error('type') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                        </div>

                        <div x-show="type === 'page'">
                            <label for="lp_page_id" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Select Page <span class="text-red-500">*</span></label>
                            <select id="lp_page_id" name="lp_page_id"
                                    class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('lp_page_id') border-red-500 @enderror">
                                <option value="">-- Select a Page --</option>
                                @foreach($availablePages as $id => $pageTitle)
                                    <option value="{{ $id }}" {{ old('lp_page_id') == $id ? 'selected' : '' }}>{{ $pageTitle }}</option>
                                @endforeach
                            </select>
                            @error('lp_page_id') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                        </div>

                        <div x-show="type === 'url'">
                            <label for="item_url" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Custom URL <span class="text-red-500">*</span></label>
                            <input type="url" id="item_url" name="url" value="{{ old('url') }}" placeholder="https://example.com"
                                   class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('url') border-red-500 @enderror">
                            @error('url') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                        </div>

                        <div x-show="type === 'route'">
                            <label for="item_route_name" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Route Name <span class="text-red-500">*</span></label>
                            <input type="text" id="item_route_name" name="route_name" value="{{ old('route_name') }}" placeholder="e.g., frontend.contact"
                                   class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('route_name') border-red-500 @enderror">
                            @error('route_name') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                            {{-- To enable route parameters, uncomment the following block and ensure your controller handles it.
                            <label for="item_route_parameters" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1 mt-2">Route Parameters (JSON)</label>
                            <input type="text" id="item_route_parameters" name="route_parameters" value="{{ old('route_parameters', '{}') }}" placeholder='{"slug":"about-us"}'
                                   class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                            --}}
                        </div>

                        <div>
                            <label for="item_target" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Target</label>
                            <select id="item_target" name="target"
                                    class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                                <option value="_self" {{ old('target', '_self') == '_self' ? 'selected' : '' }}>Same Window (_self)</option>
                                <option value="_blank" {{ old('target') == '_blank' ? 'selected' : '' }}>New Window (_blank)</option>
                            </select>
                        </div>

                        <div>
                            <label for="item_icon_class" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Icon Class (Optional)</label>
                            <select id="item_icon_class" name="icon_class"
                                    class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('icon_class') border-red-500 @enderror">
                                @if(isset($availableIcons) && is_array($availableIcons))
                                    @foreach($availableIcons as $class => $label)
                                        <option value="{{ $class }}" {{ old('icon_class') == $class ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                            @error('icon_class') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label for="item_css_class" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Custom CSS Class (Optional)</label>
                            <input type="text" id="item_css_class" name="css_class" value="{{ old('css_class') }}"
                                   class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                        </div>

                         <div>
                            <label for="parent_id" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Parent Item (for sub-menu)</label>
                            <select id="parent_id" name="parent_id"
                                    class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                                <option value="" {{ old('parent_id') == '' ? 'selected' : '' }}>-- No Parent (Root Item) --</option>
                                @foreach ($menu->rootItems as $rootItem)
                                    @include('landingpage::admin.menus.partials.menu-item-option-for-add', [
                                        'item' => $rootItem,
                                        'currentParentId' => old('parent_id'),
                                        'indent' => ''
                                        // No need to pass itemIdToExclude for the "Add New" form
                                    ])
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label for="item_is_active" class="flex items-center">
                                <input type="checkbox" id="item_is_active" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}
                                       class="form-checkbox h-4 w-4 text-blue-600 dark:bg-slate-700 dark:border-slate-600 rounded focus:ring-blue-500">
                                <span class="ml-2 text-sm text-slate-700 dark:text-slate-300">Active</span>
                            </label>
                            @error('is_active') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-green-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-600 active:bg-green-700 focus:outline-none focus:border-green-700 focus:ring ring-green-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Add Item
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('module_scripts')
{{-- Updated to Alpine.js v3 for consistency with menu-item-display modal transitions --}}


{{-- SortableJS for drag-and-drop reordering --}}
<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"></script>
<script>
    // Define global JS variables needed by sortable-script.blade.php
    const menuReorderUrl = "{{ route('admin.landingpage.menus.items.reorder', $menu->id) }}";
    const csrfToken = "{{ csrf_token() }}";
</script>
@include('landingpage::admin.menus.partials.sortable-script') {{-- Include the sortable script partial --}}
@endpush
