<?php

namespace Modules\LandingPage\Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting; // Assuming your Setting model is in App\Models

class LandingPageDefaultSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $settings = [
            // General Site Branding (can also be in a main App SettingsSeeder)
            [
                'name' => 'Site Name',
                'key' => 'site_name',
                'value' => 'Digital Vocano',
                'type' => 'text',
                'group' => 'General',
            ],
            [
                'name' => 'Site Tagline',
                'key' => 'site_tagline',
                'value' => 'Innovative Solutions for a Digital World.',
                'type' => 'text',
                'group' => 'General',
            ],
            [
                'name' => 'Site Logo Path (e.g., settings_uploads/logo.png)',
                'key' => 'site_logo',
                'value' => null, // Admin will upload this
                'type' => 'file',
                'group' => 'General',
            ],
            [
                'name' => 'Site Favicon Path (e.g., settings_uploads/favicon.ico)',
                'key' => 'site_favicon',
                'value' => null, // Admin will upload this
                'type' => 'file',
                'group' => 'General',
            ],
            // LandingPage Module Specific Settings
            [
                'name' => 'Active Landing Page Theme',
                'key' => 'landingpage_active_theme',
                'value' => 'general',
                'type' => 'select', // Options managed by ThemeSettingController or module.json
                'group' => 'Landing Page',
            ],
            [
                'name' => 'Homepage Slug',
                'key' => 'landingpage_homepage_slug',
                'value' => 'home',
                'type' => 'text',
                'group' => 'Landing Page',
            ],
            // Global SEO Settings
            [
                'name' => 'SEO Title Suffix (Appended after page title)',
                'key' => 'landingpage_seo_title_suffix',
                'value' => 'Digital Vocano',
                'type' => 'text',
                'group' => 'Landing Page SEO',
            ],
            [
                'name' => 'Global Meta Description (Fallback)',
                'key' => 'landingpage_global_meta_description',
                'value' => 'Welcome to Digital Vocano, your partner for innovative digital solutions and cutting-edge web development.',
                'type' => 'textarea',
                'group' => 'Landing Page SEO',
            ],
            [
                'name' => 'Global Meta Keywords (Comma-separated)',
                'key' => 'landingpage_global_meta_keywords',
                'value' => 'digital vocano, web development, software, portfolio, laravel modules',
                'type' => 'text',
                'group' => 'Landing Page SEO',
            ],
            // Add more settings like contact_email, contact_phone, social media URLs etc.
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(['key' => $setting['key']], $setting);
        }

        $this->command->info('Landing page default settings seeded successfully!');
    }
}