<?php

namespace Modules\LandingPage\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

class LandingPageDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard(); // Temporarily disable mass assignment protection

        $this->call(LpPageSeeder::class);
        $this->call(LandingPageDefaultSettingsSeeder::class);
        $this->call(LandingPagePermissionsSeeder::class); // Seeds permissions & example roles

        Model::reguard(); // Re-enable mass assignment protection

        $this->command->info('LandingPage module has been seeded successfully, including permissions!');
    }
}