<?php

namespace Modules\LandingPage\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreLpPageApiRequest extends FormRequest
{
    public function authorize()
    {
        // Add authorization logic here if needed, e.g., check user permissions
        return true; // Or auth()->user()->can('create_lppage');
    }

    public function rules()
    {
        return [
            'title' => 'required|string|max:255',
            'slug' => 'nullable|string|max:255|unique:lp_pages,slug',
            'content' => 'nullable|string',
            'meta_title' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:500',
            'meta_keywords' => 'nullable|string|max:255',
            'theme_template' => 'nullable|string|max:255',
            'is_published' => 'sometimes|boolean',
            'sort_order' => 'sometimes|integer',
        ];
    }
}
