<?php

namespace Modules\LandingPage\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Facades\View as ViewFacade;
use Modules\LandingPage\Entities\LpPageSection as SectionModel;

class LandingPageSection extends Component
{
    public SectionModel $section;
    public string $activeTheme;

    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct(SectionModel $section, string $activeTheme)
    {
        $this->section = $section;
        $this->activeTheme = $activeTheme;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $viewPath = "landingpage::themes.{$this->activeTheme}.sections.{$this->section->type}";
        
        if (ViewFacade::exists($viewPath)) {
            return view($viewPath, [
                'section' => $this->section,
                'title' => $this->section->title,
                'content' => $this->section->content, // Pass the content array
                'activeTheme' => $this->activeTheme // Pass activeTheme if needed by section partials
            ]);
        }

        // Fallback to the section-not-found view, passing necessary data for context
        return view('landingpage::components.section-not-found', [
            'section' => $this->section, // Pass the section object for context
            'activeTheme' => $this->activeTheme
        ]);
    }
}