<?php

namespace Modules\LandingPage\Policies;

use App\Models\User; // Assuming your User model is in App\Models
use Modules\LandingPage\Entities\LpPage;
use Illuminate\Auth\Access\HandlesAuthorization;

class LpPagePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     * Requires an authenticated user.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        // Check if the user has the permission to view any landing pages.
        // This permission name ('view any lppages') should match what you define
        // in your Spatie permission setup.
        return $user->can('view any lppages');
    }

    /**
     * Determine whether the user can view the model.
     * Requires an authenticated user.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\LandingPage\Entities\LpPage  $lpPage
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, LpPage $lpPage)
    {
        // Check if the user has permission to view this specific landing page.
        // You could add more granular logic, e.g., allow viewing only if $lpPage->is_published
        // AND the user has the 'view lppages' permission.
        return $user->can('view lppages');
    }

    /**
     * Determine whether the user can create models.
     * Requires an authenticated user.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        // Only users with the 'create lppages' permission can create pages.
        return $user->can('create lppages');
    }

    /**
     * Determine whether the user can update the model.
     * Requires an authenticated user.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\LandingPage\Entities\LpPage  $lpPage
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user, LpPage $lpPage)
    {
        // Only users with the 'update lppages' permission can update pages.
        return $user->can('update lppages');
    }

    /**
     * Determine whether the user can delete the model.
     * Requires an authenticated user.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\LandingPage\Entities\LpPage  $lpPage
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, LpPage $lpPage)
    {
        // Prevent deletion of the designated homepage.
        if (function_exists('setting') && $lpPage->slug === setting('landingpage_homepage_slug', 'home')) {
            return false;
        }
        // Only users with the 'delete lppages' permission can delete other pages.
        return $user->can('delete lppages');
    }

    /**
     * Determine whether the user can restore the model. (If using SoftDeletes)
     */
    // public function restore(User $user, LpPage $lpPage): bool { return $user->can('restore lppages'); }

    /**
     * Determine whether the user can permanently delete the model. (If using SoftDeletes)
     */
    // public function forceDelete(User $user, LpPage $lpPage): bool { return $user->can('force_delete lppages'); }
}