{{--
    Image Left, Text Right Layout
    Expects $section and $content.
    Required content fields: 'image_url', 'text_content'
    Optional: 'title', 'subtitle', 'button_text', 'button_link', 'image_alt'
--}}
<section id="section-{{ $section->id }}" class="py-12 md:py-20 {{ $content['bg_color'] ?? 'bg-white dark:bg-gray-800' }} {{ $content['text_color'] ?? 'text-gray-800 dark:text-gray-200' }}">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        @if(!empty($content['title']))
            <h2 class="text-3xl md:text-4xl font-bold {{ $content['title_align'] ?? 'text-center' }} mb-4">{{ $content['title'] }}</h2>
        @endif
        @if(!empty($content['subtitle']))
            <p class="text-lg {{ $content['subtitle_align'] ?? 'text-center' }} text-gray-600 dark:text-gray-400 mb-12 max-w-2xl {{ ($content['subtitle_align'] ?? 'text-center') == 'text-center' ? 'mx-auto' : '' }}">{{ $content['subtitle'] }}</p>
        @endif

        <div class="flex flex-wrap md:flex-nowrap items-center -mx-4">
            <div class="w-full md:w-1/2 px-4 mb-8 md:mb-0">
                @if(!empty($content['image_url']))
                    <img src="{{ $content['image_url'] }}" alt="{{ $content['image_alt'] ?? $content['title'] ?? 'Section Image' }}" class="rounded-lg shadow-xl w-full h-auto object-cover {{ $content['image_class'] ?? '' }}">
                @else
                    <div class="bg-gray-200 dark:bg-gray-700 rounded-lg shadow-xl w-full aspect-video flex items-center justify-center text-gray-500">Image Placeholder</div>
                @endif
            </div>
            <div class="w-full md:w-1/2 px-4 md:ps-8"> {{-- Use ps- for LTR/RTL padding start --}}
                @if(!empty($content['text_content']))
                    <div class="prose prose-lg lg:prose-xl dark:prose-invert max-w-none">{!! $content['text_content'] !!}</div>
                @endif

                @if(!empty($content['button_text']) && !empty($content['button_link']))
                    <div class="mt-8 {{ $content['button_align'] ?? 'text-left' }}">
                        <a href="{{ $content['button_link'] }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-6 rounded-lg text-md shadow-md hover:shadow-lg transition-all duration-300 {{ $content['button_class'] ?? '' }}">
                            {{ $content['button_text'] }}
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</section>