<?php

namespace Modules\LandingPage\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class LpPageSection extends Model
{
    use HasFactory;

    protected $table = 'lp_page_sections';

    protected $fillable = [
        'lp_page_id',
        'type',
        'title',
        'content',
        'sort_order',
        'layout', // Add this line
    ];

    protected $casts = [
        'content' => 'array', // Automatically cast JSON to array and vice-versa
    ];

    public function lpPage() {
        return $this->belongsTo(LpPage::class);
    }
}