<?php

namespace Modules\LandingPage\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Str;

class LpPage extends Model
{
    use HasFactory;

    protected $table = 'lp_pages';

    protected $fillable = [
        'title',
        'slug',
        'content',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'theme_template',
        'is_published',
        'sort_order',
    ];

    protected $casts = [
        'is_published' => 'boolean',
    ];

    protected static function booted(): void
    {
        static::creating(function ($page) {
            if (empty($page->slug)) {
                $page->slug = Str::slug($page->title);
            }
            // Ensure slug uniqueness
            $originalSlug = $page->slug;
            $count = 1;
            while (static::where('slug', $page->slug)->exists()) {
                $page->slug = $originalSlug . '-' . $count++;
            }
        });
    }

    protected static function newFactory()
    {
        // return \Modules\LandingPage\Database\factories\LpPageFactory::new(); // Create if needed
    }

    public function sections()
    {
        return $this->hasMany(LpPageSection::class)->orderBy('sort_order');
    }
}