@extends('layouts.admin')

@section('title', 'Edit Project: ' . $project->name)
@section('header_title', 'Edit Project: ' . $project->name)

@section('content')
<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        @include('admin.partials.alerts')

        <form action="{{ route('admin.digitalvocano.projects.update', $project) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            @include('digitalvocano::admin.projects._form', ['project' => $project])
        </form>
    </div>
</div>
@endsection