<?php

namespace Modules\DigitalVocano\Http\Controllers;

use App\Http\Controllers\Controller;
use Modules\DigitalVocano\Entities\Project;

class ProjectDisplayController extends Controller
{
    /**
     * Display a listing of published projects.
     */
    public function index()
    {
        $projects = Project::where('is_published', true)->orderBy('sort_order')->paginate(setting('digitalvocano_projects_per_page', 9));
        return view('digitalvocano::site.projects.index', compact('projects'));
    }

    /**
     * Display a single project.
     */
    public function show($slug)
    {
        $project = Project::where('slug', $slug)->where('is_published', true)->firstOrFail();
        return view('digitalvocano::site.projects.show', compact('project'));
    }
}