# CodeCatalyst Pro Module

## Description

CodeCatalyst Pro is an AI-powered developer tool designed to analyze existing Laravel backend applications and assist in scaffolding a corresponding frontend. It parses your Laravel project's structure (models, controllers, routes, etc.) and leverages AI to generate initial frontend code in various frameworks (e.g., Blade with TailwindCSS, Livewire, Vue.js). Generated code can be downloaded, pushed to cPanel, or a GitHub repository.

## Core Features

*   **Laravel Project Analysis:**
    *   Supports project input via ZIP upload or Git repository connection (GitHub, GitLab, Bitbucket).
    *   Deep parsing of routes, models (attributes, relationships, fillable/guarded), controllers (actions, data to views), migrations (schema), FormRequests (validation), and API Resources.
    *   Generates a structured report of the backend architecture.
*   **AI-Powered Frontend Generation:**
    *   User selects the desired frontend technology stack (e.g., Blade & Tailwind, Livewire, Vue.js, React).
    *   AI generates views/components for CRUD operations (list/table views, create/edit forms, show/detail views), and basic navigation menus.
    *   For SPAs, generates basic API service files/components.
    *   Supports prompt-based refinement of generated code (e.g., "Make the user table more compact", "Add a search filter to products").
*   **Flexible Output Options:**
    *   Download the generated frontend as a ZIP archive.
    *   Automated deployment to cPanel hosting (requires cPanel credentials/API access).
    *   Push generated code to a new or existing GitHub repository (requires GitHub OAuth/PAT).
*   **In-App Code Preview & Minor Edits:** Review and make small adjustments to the generated code within the application.
*   **Project Management Dashboard:** Manage analyzed projects, track generation status, and access export/deployment options.
*   **AI Model Integration:** Utilizes Large Language Models (LLMs like OpenAI's GPT, Google's Gemini) for code interpretation and generation, requiring API key configuration.

## Installation & Setup

1.  Ensure the module is enabled in your main application's module configuration.
2.  Run migrations: `php artisan module:migrate CodeCatalystPro`
3.  **Dependencies:** This module requires `nikic/php-parser` for PHP code analysis. Install via composer: `composer require nikic/php-parser`.
4.  **Admin Panel Setup:**
    *   Navigate to CodeCatalyst Pro -> Settings.
    *   Configure API keys for the chosen AI model provider (e.g., OpenAI, Gemini).
    *   Optionally, configure global GitHub OAuth application details if allowing users to connect their GitHub accounts for repository pushing.
    *   Review cPanel deployment settings and security considerations (e.g., recommend using API tokens over direct passwords).

## Workflow

1.  **Create a New Project:** From the CodeCatalyst Pro dashboard, start a new analysis project.
2.  **Provide Laravel Source:** Upload your Laravel project as a ZIP file or connect to its Git repository.
3.  **Run Analysis:** Initiate the backend analysis process. Review the generated architecture report.
4.  **Configure Frontend Generation:**
    *   Select your target frontend framework.
    *   Provide any specific instructions or prompts for the AI.
5.  **Generate Frontend:** Let the AI generate the initial frontend code.
6.  **Review & Refine:** Use the in-app editor to preview and tweak the code. Use prompts for further AI assistance.
7.  **Export/Deploy:** Download the code, push to cPanel, or push to GitHub.

## Important Considerations

*   **AI Output Quality:** AI-generated code is a starting point and will likely require manual review and refinement by a developer for production use.
*   **Complexity:** The accuracy and completeness of frontend generation depend heavily on the complexity, conventions, and clarity of the analyzed Laravel backend.
*   **Security:**
    *   When connecting to Git repositories or cPanel, ensure secure handling of credentials (OAuth, Personal Access Tokens, or API tokens are preferred over direct passwords).
    *   The analysis process reads code; ensure no sensitive data is inadvertently exposed if the tool is made publicly accessible or used on untrusted codebases.

## Supported Technologies (Examples)

*   **Backend Analysis:** Laravel (configurable for specific version ranges).
*   **Frontend Generation (Targets):** Blade & TailwindCSS, Livewire, Vue.js, React (expandable list).
*   **Deployment:** ZIP Download, cPanel (via API or secure FTP/SSH), GitHub.