{{-- d:\projects\digitalvocano\Modules\BusinessDirectory\resources\views\frontend\tenders\show_my_tender.blade.php --}}
<x-app-layout>
    @section('title', 'My Tender: ' . $tender->title)

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('My Tender: ') }} <span class="text-purple-600 dark:text-purple-400">{{ $tender->title }}</span>
            </h2>
            <div class="mt-4 md:mt-0 flex items-center space-x-3">
                 <a href="{{ route('frontend.businessdirectory.tenders.show', $tender->slug) }}" target="_blank" class="px-4 py-2 text-sm font-medium tracking-wide text-gray-700 capitalize transition-colors duration-300 transform bg-gray-200 rounded-md dark:text-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50">
                    {{ __('View Public Listing') }}
                </a>
                <a href="{{ route('frontend.businessdirectory.my-tenders.edit', $tender->slug) }}"
                   class="px-4 py-2 text-sm font-medium tracking-wide text-white capitalize transition-colors duration-300 transform bg-blue-600 rounded-md hover:bg-blue-500 focus:outline-none focus:ring focus:ring-blue-300 focus:ring-opacity-50">
                    {{ __('Edit Tender') }}
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
                <h3 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Tender Details</h3>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 text-gray-700 dark:text-gray-300 text-sm">
                    <div><strong>Company:</strong> {{ $tender->company->name ?? 'N/A' }}</div>
                    <div><strong>Status:</strong> <span class="font-semibold">{{ ucfirst($tender->status) }}</span></div>
                    <div><strong>Deadline:</strong> {{ $tender->deadline->format('M d, Y H:i A') }} ({{ $tender->deadline->diffForHumans() }})</div>
                    @if($tender->budget_min || $tender->budget_max)
                    <div><strong>Budget:</strong> {{ $tender->budget_min ? number_format($tender->budget_min, 2) : 'N/A' }} - {{ $tender->budget_max ? number_format($tender->budget_max, 2) : 'N/A' }} {{ $tender->currency }}</div>
                    @endif
                    @if($tender->location)
                    <div><strong>Location:</strong> {{ $tender->location }}</div>
                    @endif
                    @if($tender->category)
                    <div><strong>Category:</strong> {{ $tender->category->name }}</div>
                    @endif
                </div>

                <div class="mt-6">
                    <h4 class="text-lg font-semibold text-gray-800 dark:text-white mb-2">Description</h4>
                    <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                        {!! nl2br(e($tender->description)) !!}
                    </div>
                </div>

                @if($tender->additionalAttachments->isNotEmpty())
                <div class="mt-6">
                    <h4 class="text-lg font-semibold text-gray-800 dark:text-white mb-2">Attachments</h4>
                    <ul class="space-y-2 text-sm">
                        @foreach($tender->additionalAttachments as $attachment)
                        <li>
                            <a href="{{ $attachment->url }}" target="_blank" class="text-blue-600 dark:text-blue-400 hover:underline flex items-center">
                                <i class="fas fa-file-alt mr-2"></i> {{ $attachment->original_name }} ({{ $attachment->readable_size }})
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </div>
                @endif

                <div class="mt-8 pt-6 border-t dark:border-gray-700">
                    <h3 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4">Bids Received ({{ $tender->bids->count() }})</h3>
                    @if($tender->bids->isEmpty())
                        <p class="text-gray-600 dark:text-gray-400">No bids have been submitted for this tender yet.</p>
                    @else
                        <div class="space-y-6">
                            @foreach($tender->bids as $bid)
                                {{-- Include a partial for displaying a single bid --}}
                                {{-- You'll need to create this partial: _bid_card_for_owner.blade.php --}}
                                @include('businessdirectory::frontend.tenders.partials._bid_card_for_owner', ['bid' => $bid])
                            @endforeach
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </div>
</x-app-layout>