<x-app-layout>
    @section('title', __('My Posted Tenders'))

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('My Posted Tenders') }}
            </h2>
            <a href="{{ route('frontend.businessdirectory.my-tenders.create') }}"
               class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-white capitalize transition-colors duration-300 transform bg-blue-600 rounded-md hover:bg-blue-500 focus:outline-none focus:ring focus:ring-blue-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-plus mr-2"></i> {{ __('Post New Tender') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Session messages are handled by app.blade.php --}}

            {{-- Search and Filter Form --}}
            <form method="GET" action="{{ route('frontend.businessdirectory.my-tenders.index') }}" class="mb-8 p-6 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                    <div>
                        <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Search by Tender Title</label>
                        <input type="text" name="search" id="search" value="{{ request('search') }}"
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                               placeholder="e.g., Office Renovation">
                    </div>
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                        <select name="status" id="status"
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                            <option value="">All Statuses</option>
                            @php
                                // Assuming Tender model has a getStatuses() method or similar
                                $tenderStatuses = \Modules\BusinessDirectory\Entities\Tender::getStatuses();
                            @endphp
                            @foreach($tenderStatuses as $key => $value)
                                <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <button type="submit"
                                class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Filter Tenders
                        </button>
                    </div>
                </div>
            </form>

            @if($myTenders->isEmpty())
                <div class="text-center py-12 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                    <i class="fas fa-file-signature fa-3x text-gray-400 dark:text-gray-500 mb-3"></i>
                    <h3 class="mt-2 text-lg font-medium text-gray-900 dark:text-gray-100">No Tenders Posted Yet</h3>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                        You haven't posted any tenders. Start by posting one to find interested businesses.
                    </p>
                    <div class="mt-6">
                        <a href="{{ route('frontend.businessdirectory.my-tenders.create') }}"
                           class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Post Your First Tender
                        </a>
                    </div>
                </div>
            @else
                <div class="overflow-x-auto bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Title</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Company</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Bids</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Deadline</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @foreach ($myTenders as $tender)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-gray-100">
                                        <a href="{{ route('frontend.businessdirectory.tenders.show', $tender->slug) }}" class="hover:text-blue-600 dark:hover:text-blue-400" target="_blank">{{ Str::limit($tender->title, 40) }}</a>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $tender->company->name ?? 'N/A' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                            @if($tender->status == 'open') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100 @endif
                                            @if($tender->status == 'closed') bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-100 @endif
                                            @if($tender->status == 'awarded') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100 @endif
                                            @if($tender->status == 'cancelled') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100 @endif
                                            @if($tender->status == 'draft') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100 @endif
                                        ">
                                            {{ Str::title(str_replace('_', ' ', $tender->status)) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $tender->bids_count }}
                                        @if($tender->bids_count > 0)
                                            <a href="{{ route('frontend.businessdirectory.my-tenders.bids', $tender->slug) }}" class="ml-1 text-xs text-blue-500 dark:text-blue-400 hover:underline">(View)</a>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ \Carbon\Carbon::parse($tender->deadline ?? $tender->deadline_for_bids)->format('M d, Y') }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <a href="{{ route('frontend.businessdirectory.my-tenders.edit', $tender->slug) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300 mr-3">Edit</a>
                                        {{-- Add other actions like close, cancel, delete with appropriate checks --}}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @if($myTenders->hasPages())
                <div class="p-6 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700">
                    {{ $myTenders->appends(request()->query())->links() }}
                </div>
                @endif
            @endif
        </div>
    </div>
</x-app-layout>
