<x-app-layout>
    @section('title', __('Edit Tender: ') . $tender->title)

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('Edit Tender') }}
            </h2>
            <a href="{{ route('frontend.businessdirectory.my-tenders.index') }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-gray-700 dark:text-gray-300 capitalize transition-colors duration-300 transform bg-gray-200 dark:bg-gray-700 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> {{ __('Back to My Tenders') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-3xl mx-auto bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6 md:p-8">
            {{-- Session Messages --}}
            @if (session('error'))
                <div class="mb-6 p-4 border-l-4 border-red-400 bg-red-50 text-red-700 dark:bg-red-900/30 dark:text-red-300 dark:border-red-600 rounded-md shadow-sm" role="alert">
                     <div class="flex">
                        <div class="flex-shrink-0">
                            {{-- Error Icon --}}
                            <x-heroicon-s-x-circle class="h-5 w-5 text-red-500 dark:text-red-400" />
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium">{{ session('error') }}</p>
                        </div>
                    </div>
                </div>
            @endif

            <form action="{{ route('frontend.businessdirectory.my-tenders.update', $tender->slug) }}" method="POST" enctype="multipart/form-data">
                @csrf {{-- Add CSRF token --}}
                @method('PUT') {{-- Standard method for updates --}}
                {{--
                    Pass userCompanies, which are the companies owned by the user.
                    The company_id field in the form partial is disabled during edit.
                --}}
                @include('businessdirectory::frontend.tenders._my_tender_form', [
                    'tender' => $tender,
                    'userCompanies' => $userCompanies, // Pass the user's companies
                    'isEdit' => true {{-- Optional flag for the form partial --}}
                ])
            </form>
        </div>
    </div>
</x-app-layout>
