<x-app-layout>
    @section('title', __('Post a New Tender'))

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('Post a New Tender') }}
            </h2>
            <a href="{{ route('frontend.businessdirectory.my-tenders.index') }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-gray-700 dark:text-gray-300 capitalize transition-colors duration-300 transform bg-gray-200 dark:bg-gray-700 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> {{ __('Back to My Tenders') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-3xl mx-auto bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6 md:p-8">
                <form action="{{ route('frontend.businessdirectory.my-tenders.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @include('businessdirectory::frontend.tenders._my_tender_form', [
                        'tender' => $tender,
                        'userCompanies' => $userCompanies,
                        'isEdit' => false
                    ])
                </form>
            </div>
        </div>
    </div>
</x-app-layout>