{{--
    This partial expects:
    - $tender: The Tender model instance (can be new for create)
    - $userCompanies: Collection of companies owned by the user (for create/edit if applicable)
    - $isEdit: Boolean, true if editing, false if creating (optional, for button text)
--}}
<div class="space-y-6">
    @if(isset($userCompanies) && $userCompanies->count() > 1)
        <div>
            <label for="company_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Posting Company <span class="text-red-500">*</span></label>
            <select name="company_id" id="company_id" required
                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md @error('company_id') border-red-500 @enderror">
                @foreach($userCompanies as $id => $name)
                    <option value="{{ $id }}" {{ (old('company_id', $tender->company_id ?? '') == $id) ? 'selected' : '' }}>
                        {{ $name }}
                    </option>
                @endforeach
            </select>
            @error('company_id') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    @elseif(isset($userCompanies) && $userCompanies->count() == 1)
        {{-- If user has only one company, pre-select it and hide the field --}}
        <input type="hidden" name="company_id" value="{{ $userCompanies->keys()->first() }}">
        <div class="mb-4 p-3 bg-gray-100 dark:bg-gray-700 rounded-md">
            <p class="text-sm text-gray-700 dark:text-gray-300">Posting for company: <span class="font-semibold">{{ $userCompanies->first() }}</span></p>
        </div>
    @endif

    <div>
        <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Tender Title <span class="text-red-500">*</span></label>
        <input type="text" name="title" id="title" value="{{ old('title', $tender->title ?? '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('title') border-red-500 @enderror">
        @error('title') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Detailed Description <span class="text-red-500">*</span></label>
        <textarea name="description" id="description" rows="6" required
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('description') border-red-500 @enderror">{{ old('description', $tender->description ?? '') }}</textarea>
        @error('description') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="requirements" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Specific Requirements (Optional)</label>
        <textarea name="requirements" id="requirements" rows="4"
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('requirements') border-red-500 @enderror">{{ old('requirements', $tender->requirements ?? '') }}</textarea>
        @error('requirements') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="budget_min" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Minimum Budget (Optional)</label>
            <input type="number" name="budget_min" id="budget_min" value="{{ old('budget_min', $tender->budget_min ?? '') }}" step="0.01" min="0"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('budget_min') border-red-500 @enderror">
            @error('budget_min') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="budget_max" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Maximum Budget (Optional)</label>
            <input type="number" name="budget_max" id="budget_max" value="{{ old('budget_max', $tender->budget_max ?? '') }}" step="0.01" min="0"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('budget_max') border-red-500 @enderror">
            @error('budget_max') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>
    <div>
        <label for="currency" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Budget Currency (e.g., USD, EUR)</label>
        <input type="text" name="currency" id="currency" value="{{ old('currency', $tender->currency ?? 'USD') }}" maxlength="3"
               class="mt-1 block w-full md:w-1/2 border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('currency') border-red-500 @enderror">
        @error('currency') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="deadline" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Deadline for Bids <span class="text-red-500">*</span></label>
        <input type="date" name="deadline" id="deadline" value="{{ old('deadline', isset($tender->deadline) ? $tender->deadline->format('Y-m-d') : (new \Carbon\Carbon())->addWeeks(2)->format('Y-m-d')) }}" required
               class="mt-1 block w-full md:w-1/2 border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('deadline') border-red-500 @enderror">
        @error('deadline') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    {{-- Add other fields like category, attachments if needed --}}

    <div class="pt-5">
        <div class="flex justify-end space-x-3">
            <a href="{{ route('frontend.businessdirectory.my-tenders.index') }}"
               class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Cancel
            </a>
            <button type="submit"
                    class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                {{ ($isEdit ?? false) ? 'Update Tender' : 'Post Tender' }}
            </button>
        </div>
    </div>
</div>
