<x-app-layout>
    @section('title', __('Add New Task to Project: ') . $project->name)

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <div>
                <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                    {{ __('Add New Task') }}
                </h2>
                <p class="text-sm text-gray-500 dark:text-gray-400">
                    For Project: <a href="{{ route('frontend.businessdirectory.my-projects.show', $project->id) }}" class="text-purple-600 dark:text-purple-400 hover:underline">{{ $project->name }}</a>
                </p>
            </div>
            <a href="{{ route('frontend.businessdirectory.my-projects.show', $project->id) }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-gray-700 dark:text-gray-300 capitalize transition-colors duration-300 transform bg-gray-200 dark:bg-gray-700 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> {{ __('Back to Project') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-2xl mx-auto bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
                <form action="{{ route('frontend.businessdirectory.my-projects.tasks.store', $project->id) }}" method="POST">
                    @csrf
                    {{-- Include a partial form if you have one, or define fields here --}}
                    {{-- Assuming a _task_form.blade.php partial --}}
                    @include('businessdirectory::frontend.tasks._task_form', ['task' => new \Modules\BusinessDirectory\Entities\CompanyTask(), 'project' => $project, 'assignees' => $assignees, 'task_statuses' => $task_statuses ?? [], 'priorities' => $priorities ?? []])

                    <div class="mt-6 flex justify-end space-x-3">
                        <a href="{{ route('frontend.businessdirectory.my-projects.show', $project->id) }}" class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Cancel
                        </a>
                        <button type="submit" class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                            Add Task
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
