{{--
    This partial expects:
    - $task: The CompanyTask model instance (can be new for create)
    - $project: The parent CompanyProject model instance
    - $assignees: Collection of users for assignee dropdown
    - $task_statuses: Array of available task statuses
    - $priorities: Array of available task priorities
--}}
<div class="space-y-6">
    <div>
        <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Task Title <span class="text-red-500">*</span></label>
        <input type="text" name="title" id="title" value="{{ old('title', $task->title ?? '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-green-500 focus:border-green-500 sm:text-sm @error('title') border-red-500 @enderror">
        @error('title') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description</label>
        <textarea name="description" id="description" rows="4"
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-green-500 focus:border-green-500 sm:text-sm @error('description') border-red-500 @enderror">{{ old('description', $task->description ?? '') }}</textarea>
        @error('description') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="assignee_user_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Assign To</label>
            <select name="assignee_user_id" id="assignee_user_id"
                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-green-500 focus:border-green-500 sm:text-sm rounded-md @error('assignee_user_id') border-red-500 @enderror">
                <option value="">Unassigned</option>
                @foreach($assignees as $id => $name)
                    <option value="{{ $id }}" {{ (old('assignee_user_id', $task->assignee_user_id ?? '') == $id) ? 'selected' : '' }}>
                        {{ $name }}
                    </option>
                @endforeach
            </select>
            @error('assignee_user_id') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>

        <div>
            <label for="due_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Due Date</label>
            <input type="date" name="due_date" id="due_date" value="{{ old('due_date', isset($task->due_date) ? $task->due_date->format('Y-m-d') : '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-green-500 focus:border-green-500 sm:text-sm @error('due_date') border-red-500 @enderror">
            @error('due_date') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
            <select name="status" id="status" required
                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-green-500 focus:border-green-500 sm:text-sm rounded-md @error('status') border-red-500 @enderror">
                @php
                    $defaultStatus = $task->exists ? $task->status : 'todo';
                @endphp
                @foreach($task_statuses as $key => $value)
                    <option value="{{ $key }}" {{ (old('status', $defaultStatus) == $key) ? 'selected' : '' }}>
                        {{ $value }}
                    </option>
                @endforeach
            </select>
            @error('status') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>

        <div>
            <label for="priority" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Priority</label>
            <select name="priority" id="priority"
                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-green-500 focus:border-green-500 sm:text-sm @error('priority') border-red-500 @enderror">
                <option value="">None</option>
                @foreach($priorities as $key => $value)
                    <option value="{{ $key }}" {{ (old('priority', $task->priority ?? '') == $key) ? 'selected' : '' }}>
                        {{ $value }}
                    </option>
                @endforeach
            </select>
            @error('priority') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>
</div>
