{{--
    This partial expects:
    - $project: The CompanyProject model instance (can be new for create)
    - $companies: Collection of user's approved companies (id => name)
    - $teams: Collection of user's owned teams (id => name)
    - $isEdit: (Optional) boolean, true if editing, defaults to false.
--}}
<div class="space-y-6">
    <div>
        <label for="company_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company <span class="text-red-500">*</span></label>
        <select name="company_id" id="company_id" required {{ ($isEdit ?? false) && $project->company_id ? 'disabled' : '' }}
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-purple-500 focus:border-purple-500 sm:text-sm rounded-md @error('company_id') border-red-500 @enderror {{ ($isEdit ?? false) && $project->company_id ? 'bg-gray-100 dark:bg-gray-600 cursor-not-allowed' : '' }}">
            <option value="">Select Company</option>
            @foreach($companies as $id => $name)
                <option value="{{ $id }}" {{ (old('company_id', $project->company_id ?? '') == $id) ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </select>
        @if(($isEdit ?? false) && $project->company_id)
            <input type="hidden" name="company_id" value="{{ $project->company_id }}">
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Company cannot be changed after project creation.</p>
        @endif
        @error('company_id') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Project Name <span class="text-red-500">*</span></label>
        <input type="text" name="name" id="name" value="{{ old('name', $project->name ?? '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500 sm:text-sm @error('name') border-red-500 @enderror">
        @error('name') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="team_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Assign to Team (Optional)</label>
        <select name="team_id" id="team_id"
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-purple-500 focus:border-purple-500 sm:text-sm rounded-md @error('team_id') border-red-500 @enderror">
            <option value="">No specific team / Personal Project</option>
            @foreach($teams as $id => $name)
                <option value="{{ $id }}" {{ (old('team_id', $project->team_id ?? '') == $id) ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </select>
        @error('team_id') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description</label>
        <textarea name="description" id="description" rows="5"
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500 sm:text-sm @error('description') border-red-500 @enderror">{{ old('description', $project->description ?? '') }}</textarea>
        @error('description') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="start_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Start Date</label>
            <input type="date" name="start_date" id="start_date" value="{{ old('start_date', isset($project->start_date) ? $project->start_date->format('Y-m-d') : '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500 sm:text-sm @error('start_date') border-red-500 @enderror">
            @error('start_date') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="end_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">End Date</label>
            <input type="date" name="end_date" id="end_date" value="{{ old('end_date', isset($project->end_date) ? $project->end_date->format('Y-m-d') : '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500 sm:text-sm @error('end_date') border-red-500 @enderror">
            @error('end_date') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
        <select name="status" id="status" required
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-purple-500 focus:border-purple-500 sm:text-sm rounded-md @error('status') border-red-500 @enderror">
            @php
                $defaultStatus = ($isEdit ?? false) && isset($project->status) ? $project->status : 'planning';
            @endphp
            @foreach(\Modules\BusinessDirectory\Entities\CompanyProject::getStatuses() as $key => $value)
                <option value="{{ $key }}" {{ (old('status', $defaultStatus) == $key) ? 'selected' : '' }}>
                    {{ $value }}
                </option>
            @endforeach
        </select>
        @error('status') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="pt-8">
        <div class="flex justify-end space-x-3">
            <a href="{{ route('frontend.businessdirectory.my-projects.index') }}"
               class="bg-white dark:bg-gray-700 py-2 px-4 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                Cancel
            </a>
            <button type="submit"
                    class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 dark:focus:ring-offset-gray-800">
                {{ ($isEdit ?? false) ? 'Update Project' : 'Create Project' }}
            </button>
        </div>
    </div>
</div>