@extends('layouts.frontend')

    @section('title', $product->meta_title ?? $product->name)
    @section('meta_description', $product->meta_description ?? Str::limit(strip_tags($product->description), 160))
    @section('meta_keywords', $product->meta_keywords ?? $product->name . ', ' . ($product->company->name ?? ''))

@section('content')
    <div class="py-12">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Breadcrumbs or back link can be placed here if desired --}}
            <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
                <div class="md:flex">
                    <div class="md:w-1/2">
                        <img src="{{ $product->featured_image_url ?? asset('path/to/default-product-image.png') }}" alt="{{ $product->name }}" class="w-full h-auto object-cover md:rounded-l-lg">
                        {{-- Add gallery for multiple images if $product->images is populated --}}
                    </div>
                    <div class="md:w-1/2 p-6 md:p-8">
                        <h1 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">{{ $product->name }}</h1>
                        @if($product->company)
                        <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                            Sold by: <a href="{{ active_public_route_url('companies.show', ['company' => $product->company->slug]) }}" class="text-blue-600 hover:underline">{{ $product->company->name }}</a>
                        </p>
                        @endif

                        <p class="text-3xl font-bold text-blue-600 dark:text-blue-400 mb-4">
                            ${{ number_format($product->price, 2) }}
                            @if($product->sale_price && $product->sale_price < $product->price)
                                <span class="text-lg text-gray-500 line-through ml-2">${{ number_format($product->price, 2) }}</span>
                                <span class="ml-2 px-2 py-0.5 text-xs font-semibold bg-red-100 text-red-700 rounded-full">SALE</span>
                            @endif
                        </p>

                        <div class="text-sm text-gray-700 dark:text-gray-300 mb-4">
                            <p><strong>SKU:</strong> {{ $product->sku ?? 'N/A' }}</p>
                            <p><strong>Stock:</strong> {{ $product->stock_quantity > 0 ? $product->stock_quantity . ' available' : 'Out of Stock' }}</p>
                        </div>

                        <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300 mb-6">
                            {!! nl2br(e($product->description)) !!}
                        </div>

                        {{-- Add to Cart Form --}}
                        @if($product->status === 'published' && $product->stock_quantity > 0)
                            <form action="{{ route('frontend.businessdirectory.cart.add', $product->slug) }}" method="POST">
                                @csrf
                                <div class="flex items-center space-x-3">
                                    <input type="number" name="quantity" value="1" min="1" max="{{ $product->stock_quantity }}" class="form-input w-20 rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600">
                                    <button type="submit" class="px-6 py-3 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-md shadow-md hover:shadow-lg transition-all duration-300">
                                        <i class="fas fa-cart-plus mr-2"></i> Add to Cart
                                    </button>
                                </div>
                            </form>
                        @else
                            <p class="text-red-600 font-semibold">This product is currently unavailable.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection