<div class="space-y-6 lg:h-[calc(100vh-100px)] lg:overflow-y-auto lg:pr-4 custom-scrollbar"> {{-- Adjust 100px based on header+topbar height --}}
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-4">Directory Navigator</h2>

        {{-- General Search Filter --}}
        <form method="GET" action="{{ active_public_route_url('companies.index') }}" class="mb-6">
            <label for="sidebar_search" class="sr-only">Search Directory</label>
            <div class="relative">
                <input type="text" name="search" id="sidebar_search" placeholder="Search all listings..."
                       class="form-input w-full pl-10 pr-4 py-2 rounded-lg dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 focus:ring-purple-500 focus:border-purple-500"
                       value="{{ request('search') }}">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fas fa-search text-gray-400"></i>
                </div>
            </div>
            <button type="submit" class="mt-2 w-full bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-4 rounded-lg transition-colors">
                Search
            </button>
        </form>

        {{-- Sorting Options --}}
        <div class="mb-6">
            <label for="sidebar_sort" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Sort By</label>
            <select id="sidebar_sort" name="sort_by" class="form-select w-full rounded-lg dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 focus:ring-purple-500 focus:border-purple-500"
                    onchange="window.location.href = this.value;"> {{-- Basic JS redirect, or use Alpine/Livewire for reactivity --}}
                <option value="{{ active_public_route_url('companies.index', array_merge(request()->except(['sort', 'page']), ['sort' => 'name_asc'])) }}" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>Name (A-Z)</option>
                <option value="{{ active_public_route_url('companies.index', array_merge(request()->except(['sort', 'page']), ['sort' => 'name_desc'])) }}" {{ request('sort') == 'name_desc' ? 'selected' : '' }}>Name (Z-A)</option>
                <option value="{{ active_public_route_url('companies.index', array_merge(request()->except(['sort', 'page']), ['sort' => 'date_desc'])) }}" {{ request('sort', 'date_desc') == 'date_desc' ? 'selected' : '' }}>Newest First</option>
                <option value="{{ active_public_route_url('companies.index', array_merge(request()->except(['sort', 'page']), ['sort' => 'featured'])) }}" {{ request('sort') == 'featured' ? 'selected' : '' }}>Featured</option>
            </select>
        </div>
    </div>
    {{-- Explore on Map --}}
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Explore on Map</h3>
        <div id="leaflet-map-sidebar" class="h-64 rounded-lg bg-gray-200 dark:bg-gray-700 flex items-center justify-center text-gray-500 dark:text-gray-400 border dark:border-gray-600">
            {{-- Leaflet Map will be initialized here via JS --}}
            Map Placeholder
        </div>
        <p class="text-xs text-gray-600 dark:text-gray-400 mt-2 text-center">Find opportunities near you!</p>
    </div>

    {{-- Categories --}}
    @if(isset($sidebarCategories) && $sidebarCategories->isNotEmpty())
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Categories</h3>
        <ul class="space-y-2 text-sm">
            @foreach($sidebarCategories->take(6) as $category) {{-- Show a limited number --}}
                <li>
                    <a href="{{ active_public_route_url('category.show', ['category' => $category->slug]) }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 hover:underline flex justify-between items-center">
                        <span>{{ $category->name }}</span>
                        {{-- <span class="text-xs bg-gray-200 dark:bg-gray-700 px-2 py-0.5 rounded-full">{{ $category->companies_count + $category->products_count + $category->jobs_count + $category->tenders_count }}</span> --}}
                    </a>
                </li>
            @endforeach
            {{-- Add a "View All Categories" link if you have many --}}
        </ul>
        @if(isset($sidebarCategories) && $sidebarCategories->count() > 6) {{-- Condition to show "View All" --}}
            {{-- Make sure a route named 'categories.index' (or similar) is defined for this link to work --}}
            <a href="{{ active_public_route_url('categories.index') }}" class="text-sm text-indigo-600 hover:underline mt-3 inline-block">View All Categories &rarr;</a>
        @endif
    </div>
    @endif

    {{-- Popular Keywords --}}
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Popular Keywords</h3>
        <div class="flex flex-wrap gap-2">
            {{-- Placeholder Keywords - Replace with dynamic data from your tagging system --}}
            @foreach(['SoftwareDev', 'HarareJobs', 'TenderZimbabwe', 'OfficeSupplies', 'AgriEquip', 'Consulting'] as $keyword)
            <a href="{{ active_public_route_url('search.index', ['keyword' => $keyword]) }}" class="text-xs bg-gray-200 hover:bg-gray-300 dark:bg-gray-700 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 px-2 py-1 rounded-full">#{{$keyword}}</a>
            @endforeach
        </div>
    </div>

    {{-- Recent Activity --}}
    @if(isset($recentActivities) && $recentActivities->isNotEmpty())
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Recent Activity</h3>
        <ul class="space-y-3">
            @foreach($recentActivities as $activity)
                <li class="text-sm">
                    @if($activity instanceof \Modules\BusinessDirectory\Entities\Tender)
                        <span class="font-semibold text-purple-600 dark:text-purple-400">New Tender:</span>
                        <a href="{{ active_public_route_url('tenders.show', ['tender' => $activity->slug]) }}" class="hover:underline text-gray-700 dark:text-gray-300">{{ Str::limit($activity->title, 40) }}</a>
                    @elseif($activity instanceof \Modules\BusinessDirectory\Entities\Job)
                        <span class="font-semibold text-green-600 dark:text-green-400">New Job:</span>
                        <a href="{{ active_public_route_url('jobs.show', ['slug' => $activity->slug]) }}" class="hover:underline text-gray-700 dark:text-gray-300">{{ Str::limit($activity->title, 40) }}</a>
                    @elseif($activity instanceof \Modules\BusinessDirectory\Entities\Product)
                        <span class="font-semibold text-blue-600 dark:text-blue-400">Marketplace:</span>
                        <a href="{{ active_public_route_url('products.show', ['product' => $activity->slug]) }}" class="hover:underline text-gray-700 dark:text-gray-300">{{ Str::limit($activity->name, 40) }} added.</a>
                    @elseif($activity instanceof \Modules\BusinessDirectory\Entities\Company)
                        <span class="font-semibold text-orange-600 dark:text-orange-400">New Company:</span>
                        <a href="{{ active_public_route_url('companies.show', ['company' => $activity->slug]) }}" class="hover:underline text-gray-700 dark:text-gray-300">{{ Str::limit($activity->name, 40) }} joined.</a>
                    @endif
                    <span class="block text-xs text-gray-500 dark:text-gray-400">{{ $activity->created_at->diffForHumans() }}</span>
                </li>
            @endforeach
        </ul>
    </div>
    @endif

    {{-- Latest Tenders (Sidebar Specific) --}}
    @if(isset($sidebarLatestTenders) && $sidebarLatestTenders->isNotEmpty())
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Latest Tenders</h3>
        <ul class="space-y-3">
            @foreach($sidebarLatestTenders->take(5) as $tender)
                <li class="text-sm">
                    <a href="{{ active_public_route_url('tenders.show', ['tender' => $tender->slug]) }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 hover:underline block truncate" title="{{ $tender->title }}">
                        {{ $tender->title }}
                    </a>
                    <span class="block text-xs text-gray-500 dark:text-gray-400">Deadline: {{ $tender->deadline->format('M d, Y') }}</span>
                </li>
            @endforeach
        </ul>
    </div>
    @endif

    {{-- Quick Links --}}
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Quick Links</h3>
        <ul class="space-y-2 text-sm">
            <li><a href="{{ active_public_route_url('tenders.index') }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 hover:underline">View All Tenders</a></li>
            <li><a href="{{ active_public_route_url('jobs.index') }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 hover:underline">View All Jobs</a></li>
            <li><a href="{{ active_public_route_url('products.index') }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 hover:underline">Browse Marketplace</a></li>
            {{-- "Post an Opportunity" moved to a dedicated CTA box below --}}
        </ul>
    </div>

    {{-- Featured Businesses --}}
    @if(isset($sidebarFeaturedCompanies) && $sidebarFeaturedCompanies->isNotEmpty())
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Featured Businesses</h3>
        <ul class="space-y-3">
            @foreach($sidebarFeaturedCompanies as $company)
                <li class="flex items-center space-x-3">
                    @if($company->hasCustomLogo()) {{-- Use model helper --}}
                        <img src="{{ $company->logo_url_public }}" alt="{{$company->name}}" class="w-10 h-10 rounded-full object-contain bg-white p-0.5 border border-gray-200 dark:border-gray-600 flex-shrink-0">
                    @else
                        <span class="flex items-center justify-center w-10 h-10 rounded-full bg-gray-200 dark:bg-gray-700 text-gray-500 dark:text-gray-400 flex-shrink-0">
                            <i class="fas fa-building"></i>
                        </span>
                    @endif
                    <div>
                        <a href="{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}" class="text-sm font-medium text-gray-800 dark:text-gray-200 hover:text-indigo-600 dark:hover:text-indigo-400 hover:underline">{{ $company->name }}</a>
                        <p class="text-xs text-gray-500 dark:text-gray-400">{{ $company->companyType->name ?? '' }}</p>
                    </div>
                </li>
            @endforeach
        </ul>
    </div>
    @endif

    {{-- Locations (Placeholder) --}}
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Browse by Location</h3>
        <ul class="space-y-2 text-sm">
            {{-- This needs dynamic data. Example: --}}
            <li><a href="{{ active_public_route_url('search.index', ['location' => 'Harare']) }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 hover:underline">Harare</a></li>
            <li><a href="{{ active_public_route_url('search.index', ['location' => 'Bulawayo']) }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 hover:underline">Bulawayo</a></li>
            <li><a href="{{ active_public_route_url('search.index', ['location' => 'Mutare']) }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 hover:underline">Mutare</a></li>
        </ul>
    </div>

    {{-- Call to Action Box --}}
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 border border-gray-200 dark:border-gray-700 text-center">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Have Something to Share?</h3>
        <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
            List your job openings, tenders, or products on our platform.
        </p>
        {{-- Ensure a route named 'opportunity.create' (or similar) is defined for this link to work --}}
        <a href="{{ active_public_route_url('opportunity.create') }}" class="w-full inline-flex items-center justify-center px-4 py-2.5 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 dark:focus:ring-offset-gray-800">
            <i class="fas fa-plus-circle mr-2"></i> Post an Opportunity
        </a>
    </div>
</div>

@push('styles')
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin="" />
    <style>
        .custom-scrollbar::-webkit-scrollbar {
            width: 5px; /* For Chrome, Safari, and Opera */
        }
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background-color: #9ca3af; /* gray-400 */
            border-radius: 10px;
        }
        .custom-scrollbar {scrollbar-width: thin; scrollbar-color: #9ca3af transparent;} /* For Firefox */
    </style>
@endpush

@push('scripts')
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            if (document.getElementById('leaflet-map-sidebar')) {
                var map = L.map('leaflet-map-sidebar').setView([-17.825167, 31.033510], 10); // Default to Harare, Zimbabwe
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    maxZoom: 19,
                    attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
                }).addTo(map);
                // Add markers here based on company locations if you have them
                // L.marker([-17.825167, 31.033510]).addTo(map).bindPopup("Harare");
            }
        });
    </script>
@endpush