@props([
    'title' => 'Browse Our Listings',
    'subtitle' => 'Find exactly what you are looking for.',
    'searchActionRoute' => '#', // e.g., active_public_route_url('jobs.index')
    'searchPlaceholder' => 'Search...',
    'showFilters' => false, // Set to true to show advanced filter trigger
    'filterTargetId' => 'advanced-filters' // ID of the filter section
])
<section class="bg-gray-900 dark:bg-black text-white py-16 md:py-24 relative overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-br from-purple-700/30 via-blue-700/20 to-transparent opacity-50"></div>
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center relative z-10">
        <h1 class="text-4xl sm:text-5xl font-extrabold mb-4">{{ $title }}</h1>
        <p class="text-lg sm:text-xl text-gray-300 dark:text-gray-400 mb-8 max-w-2xl mx-auto">{{ $subtitle }}</p>

        <form method="GET" action="{{ $searchActionRoute }}" class="max-w-xl mx-auto">
            <div class="flex items-center bg-white/10 backdrop-blur-sm p-2 rounded-lg shadow-xl">
                <input type="text" name="search" value="{{ request('search') }}"
                       class="flex-grow p-3 text-gray-800 dark:text-white bg-white/80 dark:bg-gray-700/80 border-0 focus:ring-2 focus:ring-yellow-400 rounded-l-md placeholder-gray-500 dark:placeholder-gray-400"
                       placeholder="{{ $searchPlaceholder }}">
                <button type="submit"
                        class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold p-3 rounded-r-md transition duration-300">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
        @if($showFilters)
        <button @click="document.getElementById('{{ $filterTargetId }}').scrollIntoView({ behavior: 'smooth' });"
                class="mt-6 inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-yellow-500 hover:text-yellow-400 hover:bg-white/10 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-900 focus:ring-yellow-500">
            <i class="fas fa-filter mr-2"></i> Advanced Filters
        </button>
        @endif
    </div>
</section>
