<section class="py-16 bg-indigo-700 dark:bg-indigo-800 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <i class="fas fa-envelope-open-text fa-3x mb-6"></i>
        <h2 class="text-3xl font-bold mb-4">Stay Updated!</h2>
        <p class="text-lg mb-8 max-w-xl mx-auto opacity-90">
            Subscribe to our newsletter for the latest news, offers, and platform updates.
        </p>
        <form action="{{ route('frontend.businessdirectory.newsletter.subscribe') }}" method="POST" class="max-w-md mx-auto"> {{-- Create this route --}}
            @csrf
            <div class="flex items-center bg-white/20 backdrop-blur-sm p-2 rounded-lg shadow-xl">
                <input type="email" name="email" required
                       class="flex-grow p-3 text-gray-800 dark:text-white bg-white/80 dark:bg-gray-700/80 border-0 focus:ring-2 focus:ring-yellow-400 rounded-l-md placeholder-gray-500 dark:placeholder-gray-400"
                       placeholder="Enter your email address">
                <button type="submit"
                        class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold p-3 rounded-r-md transition duration-300">
                    Subscribe
                </button>
            </div>
            @error('email') <p class="text-red-300 text-sm mt-2">{{ $message }}</p> @enderror
        </form>
    </div>
</section>
