<section class="py-16 bg-gray-100 dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-800 dark:text-white sm:text-4xl">Latest Tenders</h2>
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-400">Find new opportunities and submit your bids.</p>
        </div>

        <div class="space-y-6">
            @forelse($tenders as $tender)
                <a href="{{ active_public_route_url('tenders.show', ['tender' => $tender->slug]) }}"
                   class="block bg-white dark:bg-gray-700 rounded-lg shadow-md hover:shadow-xl transition-shadow duration-300 p-6">
                    <div class="flex flex-col sm:flex-row justify-between items-start">
                        <div>
                            <h3 class="text-xl font-semibold text-purple-700 dark:text-purple-400 hover:underline">{{ $tender->title }}</h3>
                            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                Posted by: {{ $tender->company->name ?? 'N/A' }}
                                @if($tender->location)
                                    <span class="mx-1">|</span> <i class="fas fa-map-marker-alt text-xs mr-1"></i> {{ $tender->location }}
                                @endif
                            </p>
                        </div>
                        <div class="mt-3 sm:mt-0 text-sm text-gray-600 dark:text-gray-300 text-left sm:text-right">
                            <p>Deadline: <span class="font-medium">{{ $tender->deadline->format('M d, Y') }}</span> ({{ $tender->deadline->diffForHumans() }})</p>
                            @if($tender->budget_min || $tender->budget_max)
                                <p class="text-xs">Budget: {{ $tender->budget_min ? number_format($tender->budget_min,0) : 'N/A' }} - {{ $tender->budget_max ? number_format($tender->budget_max,0) : 'N/A' }} {{ $tender->currency }}</p>
                            @endif
                        </div>
                    </div>
                    <p class="mt-3 text-gray-700 dark:text-gray-300 text-sm line-clamp-2">
                        {{ Str::limit(strip_tags($tender->description), 200) }}
                    </p>
                </a>
            @empty
                <p class="text-center text-gray-500 dark:text-gray-400 py-8">No open tenders available at the moment.</p>
            @endforelse
        </div>
        @if($tenders->count() > 0)
        <div class="text-center mt-12">
            <a href="{{ active_public_route_url('tenders.index') }}"
               class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-8 rounded-lg text-lg shadow-md hover:shadow-lg transition-all duration-300">
                View All Tenders
            </a>
        </div>
        @endif
    </div>
</section>
