<section class="py-16 bg-white dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-800 dark:text-white sm:text-4xl">Latest Opportunities</h2>
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-400">Stay updated with new Tenders and Job openings.</p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            {{-- Latest Tenders --}}
            <div>
                <h3 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-6 flex items-center">
                    <i class="fas fa-file-signature mr-3 text-purple-500"></i> Recent Tenders
                </h3>
                @if($tenders->isNotEmpty())
                    <div class="space-y-6 swiper-container-tenders">
                        <div class="swiper-wrapper">
                            @foreach($tenders as $tender)
                                <div class="swiper-slide">
                                    <a href="{{ active_public_route_url('tenders.show', ['tender' => $tender->slug]) }}"
                                       class="block bg-gray-50 dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300 relative overflow-hidden">
                                        <div class="corner-tag tender-tag-home">Tender</div>
                                        <h4 class="text-lg font-semibold text-purple-700 dark:text-purple-400 mb-1 truncate">{{ $tender->title }}</h4>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mb-2">By: {{ $tender->company->name ?? 'N/A' }}</p>
                                        <p class="text-sm text-gray-600 dark:text-gray-300 line-clamp-2 mb-2">{{ Str::limit(strip_tags($tender->description), 100) }}</p>
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            <span><i class="fas fa-calendar-alt mr-1"></i> Deadline: {{ $tender->deadline->format('M d, Y') }}</span>
                                            @if($tender->location) <span class="ml-2"><i class="fas fa-map-marker-alt mr-1"></i> {{ $tender->location }}</span> @endif
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        <div class="swiper-pagination-tenders mt-4 text-center"></div>
                    </div>
                    <div class="text-right mt-6">
                        <a href="{{ active_public_route_url('tenders.index') }}" class="text-purple-600 dark:text-purple-400 hover:underline font-semibold">
                            View All Tenders <i class="fas fa-arrow-right ml-1"></i>
                        </a>
                    </div>
                @else
                    <p class="text-gray-500 dark:text-gray-400">No open tenders available right now.</p>
                @endif
            </div>

            {{-- Latest Jobs --}}
            <div>
                <h3 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-6 flex items-center">
                    <i class="fas fa-briefcase mr-3 text-blue-500"></i> Recent Jobs
                </h3>
                @if($jobs->isNotEmpty())
                    <div class="space-y-6 swiper-container-jobs">
                        <div class="swiper-wrapper">
                            @foreach($jobs as $job)
                                <div class="swiper-slide">
                                    <a href="{{ active_public_route_url('jobs.show', ['slug' => $job->slug]) }}"
                                       class="block bg-gray-50 dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300 relative overflow-hidden">
                                        <div class="corner-tag job-tag-home">Job</div>
                                        <div class="flex items-start justify-between">
                                            <div>
                                                <h4 class="text-lg font-semibold text-blue-700 dark:text-blue-400 mb-1 truncate">{{ $job->title }}</h4>
                                                <p class="text-xs text-gray-500 dark:text-gray-400 mb-2">At: {{ $job->company->name ?? 'N/A' }}</p>
                                            </div>
                                            @if($job->company && $job->company->logo)
                                                <img src="{{ $job->company->logo }}" alt="{{ $job->company->name }}" class="w-10 h-10 object-contain rounded-md ml-3">
                                            @endif
                                        </div>
                                        <p class="text-sm text-gray-600 dark:text-gray-300 line-clamp-2 mb-2 flex-grow">{{ Str::limit(strip_tags($job->description), 100) }}</p>
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            <span><i class="fas fa-map-marker-alt mr-1"></i> {{ $job->location ?? 'Remote' }}</span>
                                            <span class="ml-2"><i class="fas fa-clock mr-1"></i> {{ \Modules\BusinessDirectory\Entities\Job::getJobTypes()[$job->job_type] ?? ucfirst($job->job_type) }}</span>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        <div class="swiper-pagination-jobs mt-4 text-center"></div>
                    </div>
                     <div class="text-right mt-6">
                        <a href="{{ active_public_route_url('jobs.index') }}" class="text-blue-600 dark:text-blue-400 hover:underline font-semibold">
                            View All Jobs <i class="fas fa-arrow-right ml-1"></i>
                        </a>
                    </div>
                @else
                     <p class="text-gray-500 dark:text-gray-400">No open jobs available right now.</p>
                @endif
            </div>
        </div>
    </div>
</section>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (document.querySelector('.swiper-container-tenders .swiper-slide')) {
            new Swiper('.swiper-container-tenders', {
                loop: {{ $tenders->count() > 2 ? 'true' : 'false' }}, // Loop if more items than slidesPerView (on largest breakpoint)
                slidesPerView: 1,
                spaceBetween: 20,
                 autoplay: {
                    delay: 6000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: '.swiper-pagination-tenders',
                    clickable: true,
                },
                breakpoints: {
                    640: {
                        slidesPerView: 1,
                        spaceBetween: 20,
                    },
                    1024: { // lg breakpoint
                        slidesPerView: 2,
                        spaceBetween: 30,
                    }
                }
            });
        }

        if (document.querySelector('.swiper-container-jobs .swiper-slide')) {
            new Swiper('.swiper-container-jobs', {
                loop: {{ $jobs->count() > 2 ? 'true' : 'false' }}, // Loop if more items than slidesPerView (on largest breakpoint)
                slidesPerView: 1,
                spaceBetween: 20,
                autoplay: {
                    delay: 6500,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: '.swiper-pagination-jobs',
                    clickable: true,
                },
                 breakpoints: {
                    640: {
                        slidesPerView: 1, 
                        spaceBetween: 20,
                    },
                    1024: { // lg breakpoint
                        slidesPerView: 2,
                        spaceBetween: 30,
                    }
                }
            });
        }
    });
</script>
@endpush
