{{--
    This partial expects:
    - $job: The job model instance
--}}
<div class="bg-slate-50 dark:bg-slate-700/50 p-4 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
    <h4 class="font-semibold text-md text-gray-800 dark:text-gray-100">
        <a href="{{ active_public_route_url('jobs.show', ['slug' => $job->slug]) }}" class="hover:text-blue-600 dark:hover:text-blue-400">{{ $job->title }}</a>
    </h4>
    @if($job->company)
    <p class="text-sm text-gray-500 dark:text-gray-400">
        At: <a href="{{ active_public_route_url('companies.show', ['company' => $job->company->slug]) }}" class="hover:underline">{{ $job->company->name }}</a>
    </p>
    @endif
    <div class="text-xs text-gray-400 dark:text-gray-500 mt-1 space-x-2">
        @if($job->location)
        <span><i class="fas fa-map-marker-alt mr-1"></i>{{ $job->location }}</span>
        @endif
        @if($job->job_type)
        <span><i class="fas fa-briefcase mr-1"></i>{{ \Modules\BusinessDirectory\Entities\Job::getJobTypes()[$job->job_type] ?? Str::title($job->job_type) }}</span>
        @endif
    </div>
    @if($job->application_deadline)
    <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">
        Deadline: {{ $job->application_deadline->format('M d, Y') }}
    </p>
    @endif
</div>