<section class="relative h-[60vh] md:h-[70vh] lg:h-[80vh] text-white overflow-hidden"> {{-- Adjusted height slightly --}}
    <!-- Slides -->
    <div class="swiper-container h-full">
        <div class="swiper-wrapper">
            <!-- Slide 1: General Welcome / Search -->
            <div class="swiper-slide flex items-center justify-center" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);"> {{-- Example Gradient 1 --}}
                <div class="text-center p-8 max-w-3xl">
                    <h1 class="text-4xl sm:text-5xl md:text-6xl font-extrabold mb-6 leading-tight animate-fade-in-down">
                        {{ setting('homepage_hero_title', config('businessdirectory.homepage_hero_title')) }}
                    </h1>
                    <p class="text-lg sm:text-xl md:text-2xl mb-10 opacity-90 animate-fade-in-up animation-delay-300">
                        {{ setting('homepage_hero_subtitle', config('businessdirectory.homepage_hero_subtitle')) }}
                    </p>
                    <form method="GET" action="{{ active_public_route_url('companies.index') }}" class="max-w-xl mx-auto animate-fade-in-up animation-delay-600">
                        <div class="flex flex-col sm:flex-row items-center bg-white/20 backdrop-blur-sm p-2 rounded-lg shadow-2xl">
                            <input type="text" name="search"
                                   class="flex-grow p-3 sm:p-4 text-gray-800 dark:text-white bg-white/80 dark:bg-gray-700/80 border-0 focus:ring-2 focus:ring-yellow-400 rounded-md sm:rounded-l-md sm:rounded-r-none mb-2 sm:mb-0 placeholder-gray-500 dark:placeholder-gray-400"
                                   placeholder="{{ setting('homepage_hero_search_placeholder', config('businessdirectory.homepage_hero_search_placeholder')) }}">
                            <button type="submit"
                                    class="w-full sm:w-auto bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold p-3 sm:p-4 rounded-md sm:rounded-r-md sm:rounded-l-none transition duration-300">
                                <i class="fas fa-search mr-2 hidden sm:inline"></i> Search
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            {{-- Dynamically generated slides from settings --}}
            @for ($i = 1; $i <= 2; $i++) {{-- Loop for the number of slides you manage in settings --}}
                @php
                    $slideImage = setting('hero_slide_'.$i.'_image');
                    $slideTitle = setting('hero_slide_'.$i.'_title');
                    $slideSubtitle = setting('hero_slide_'.$i.'_subtitle');
                    $slideButtonText = setting('hero_slide_'.$i.'_button_text');
                    $slideButtonLink = setting('hero_slide_'.$i.'_button_link', '#');
                @endphp
                @if($slideTitle) {{-- Changed condition to only require title for a slide to show --}}
                    {{-- Example Gradients for dynamic slides. You can create a helper or an array of gradients to cycle through --}}
                    @php
                        $gradients = [
                            1 => 'linear-gradient(135deg, #43e97b 0%, #38f9d7 100%)', // Greenish
                            2 => 'linear-gradient(135deg, #ff8c00 0%, #ff0080 100%)', // Orange to Pink
                        ];
                        $currentGradient = $gradients[$i] ?? 'linear-gradient(135deg, #00c6ff 0%, #0072ff 100%)'; // Default Blue
                    @endphp
                    <div class="swiper-slide flex items-center justify-center" style="background: {{ $currentGradient }};">
                        {{-- Removed overlay as gradients might not need it, or you can add a subtle one if desired --}}
                        <div class="relative z-10 flex flex-col items-center justify-center h-full text-center p-8">
                            <h2 class="text-3xl md:text-5xl font-bold mb-4 animate-fade-in-down">{{ $slideTitle }}</h2>
                            @if($slideSubtitle)<p class="text-lg md:text-xl mb-8 max-w-2xl animate-fade-in-up animation-delay-300">{{ $slideSubtitle }}</p>@endif
                            @if($slideButtonText && $slideButtonLink)
                            <a href="{{ $slideButtonLink }}" class="bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-semibold py-3 px-8 rounded-lg text-lg shadow-md transition-transform hover:scale-105 animate-fade-in-up animation-delay-600">
                                {{ $slideButtonText }}
                            </a>
                            @endif
                        </div>
                    </div>
                @endif
            @endfor

        </div>
        <!-- Add Pagination -->
        <div class="swiper-pagination"></div>
        <!-- Add Navigation -->
        <div class="swiper-button-next text-white"></div>
        <div class="swiper-button-prev text-white"></div>
    </div>
</section>

@push('styles')
{{-- Swiper CSS is now imported in resources/css/app.css --}}
<style>
    .swiper-pagination-bullet-active {
        background-color: #fff !important; /* Or your theme's accent color */
    }
    .swiper-button-next, .swiper-button-prev {
        color: #fff !important; /* Or your theme's accent color */
        background-color: rgba(0,0,0,0.3);
        padding: 10px;
        border-radius: 50%;
        width: 44px;
        height: 44px;
    }
    .swiper-button-next::after, .swiper-button-prev::after {
        font-size: 20px !important;
    }
    .swiper-slide { /* Ensure slides take full height */
        height: 100%;
        display: flex; /* For centering content */
    }
    .animation-delay-300 { animation-delay: 300ms; }
    .animation-delay-600 { animation-delay: 600ms; }

    @keyframes fade-in-down {
        0% { opacity: 0; transform: translateY(-20px); }
        100% { opacity: 1; transform: translateY(0); }
    }
    .animate-fade-in-down { animation: fade-in-down 0.8s ease-out forwards; }

    @keyframes fade-in-up {
        0% { opacity: 0; transform: translateY(20px); }
        100% { opacity: 1; transform: translateY(0); }
    }
    .animate-fade-in-up { animation: fade-in-up 0.8s ease-out forwards; }
</style>
@endpush

@push('scripts')
{{-- Swiper JS is now imported and initialized in resources/js/app.js --}}
<script>
    @php
        $heroSlideCount = 1; // Start with the static welcome slide
        if (setting('hero_slide_1_title')) $heroSlideCount++;
        if (setting('hero_slide_2_title')) $heroSlideCount++;
    @endphp
    document.addEventListener('DOMContentLoaded', function () {
        var swiper = new Swiper('.swiper-container', {
            loop: {{ $heroSlideCount > 1 ? 'true' : 'false' }}, // Enable loop only if more than 1 slide
            autoplay: {
                delay: 7000, // Time in ms
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            effect: 'fade', // Optional: 'slide', 'fade', 'cube', 'coverflow', 'flip'
            fadeEffect: {
                crossFade: true
            },
        });
    });
</script>
@endpush
