<section class="bg-gradient-to-r from-blue-600 to-purple-600 text-white py-20 md:py-32">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="text-4xl sm:text-5xl md:text-6xl font-extrabold mb-6 leading-tight">
            Discover & Connect With Local Businesses
        </h1>
        <p class="text-lg sm:text-xl md:text-2xl mb-10 max-w-3xl mx-auto opacity-90">
            Your ultimate guide to finding trusted companies, top products, and valuable service tenders in your area.
        </p>

        {{-- Search Form --}}
        <form method="GET" action="{{ active_public_route_url('companies.index') }}" class="max-w-2xl mx-auto">
            <div class="flex flex-col sm:flex-row items-center bg-white dark:bg-gray-800 p-2 rounded-lg shadow-2xl">
                <input type="text" name="search"
                       class="flex-grow p-3 sm:p-4 text-gray-700 dark:text-gray-200 dark:bg-gray-700 border-0 focus:ring-2 focus:ring-purple-500 rounded-md sm:rounded-l-md sm:rounded-r-none mb-2 sm:mb-0"
                       placeholder="Search by company name, service, product...">

                <select name="company_type_slug" class="w-full sm:w-auto p-3 sm:p-4 text-gray-700 dark:text-gray-200 dark:bg-gray-700 border-0 focus:ring-2 focus:ring-purple-500 rounded-md sm:rounded-none mb-2 sm:mb-0 sm:border-l sm:border-r border-gray-200 dark:border-gray-600">
                    <option value="">All Categories</option>
                    @foreach($companyTypes as $type)
                        <option value="{{ $type->slug }}">{{ $type->name }}</option>
                    @endforeach
                </select>

                <button type="submit"
                        class="w-full sm:w-auto bg-yellow-500 hover:bg-yellow-600 text-gray-900 font-bold p-3 sm:p-4 rounded-md sm:rounded-r-md sm:rounded-l-none transition duration-300 ease-in-out transform hover:scale-105">
                    <i class="fas fa-search mr-2 hidden sm:inline"></i> Search
                </button>
            </div>
            <p class="text-sm mt-4 opacity-80">
                Or browse:
                <a href="{{ active_public_route_url('products.index') }}" class="font-semibold hover:underline">Products</a>,
                <a href="{{ active_public_route_url('tenders.index') }}" class="font-semibold hover:underline">Tenders</a>
            </p>
        </form>
    </div>
</section>
