<section class="py-16 bg-gray-50 dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-800 dark:text-white sm:text-4xl">Featured Companies</h2>
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-400">Discover leading businesses in our directory.</p>
        </div>

        <div class="swiper-container-companies"> {{-- Add Swiper container --}}
            <div class="swiper-wrapper"> {{-- Add Swiper wrapper --}}
                @forelse($companies as $company)
                    <div class="swiper-slide"> {{-- Wrap each item in a slide --}}
                        <a href="{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}" class="block bg-white dark:bg-gray-700 rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1 h-full flex flex-col group">
                            <div class="relative">
                                @if($company->hasCustomBanner())
                                    <img src="{{ $company->banner_url_public }}" alt="{{ $company->name }} banner" class="w-full h-32 object-cover transition-transform duration-300 group-hover:scale-105">
                                @else
                                    <div class="w-full h-32 bg-gradient-to-r from-slate-300 to-slate-400 dark:from-slate-600 dark:to-slate-500 flex items-center justify-center">
                                        <i class="fas fa-image text-4xl text-slate-500 dark:text-slate-400 opacity-70"></i>
                                    </div>
                                @endif
                                @if($company->hasCustomLogo())
                                    <img class="absolute -bottom-6 left-4 h-12 w-12 rounded-full object-contain bg-white dark:bg-gray-700 p-0.5 border-2 border-white dark:border-gray-600 shadow-md" src="{{ $company->logo_url_public }}" alt="{{ $company->name }} logo">
                                @else
                                    <div class="absolute -bottom-6 left-4 flex items-center justify-center h-12 w-12 rounded-full bg-gray-200 dark:bg-gray-700 border-2 border-white dark:border-gray-600 shadow-md text-gray-400 dark:text-gray-500">
                                        <i class="fas fa-building text-xl"></i>
                                    </div>
                                @endif
                            </div>
                            <div class="p-4 pt-8 flex-grow flex flex-col">
                                <h3 class="text-md font-bold text-gray-900 dark:text-white mb-1 group-hover:text-purple-600 dark:group-hover:text-purple-400 transition-colors duration-200 truncate" title="{{ $company->name }}">{{ $company->name }}</h3>
                                <p class="text-xs text-purple-600 dark:text-purple-400 font-medium mb-1">{{ $company->companyType->name ?? 'Business' }}</p>
                                @if(isset($company->average_rating) && $company->average_rating > 0)
                                    <div class="text-xs text-yellow-400 mb-2">
                                        @for ($i = 1; $i <= 5; $i++) <i class="fas fa-star{{ $i <= round($company->average_rating) ? '' : ($i - 0.5 <= $company->average_rating ? '-half-alt' : ' far fa-star') }}"></i> @endfor
                                        <span class="ml-1 text-gray-500 dark:text-gray-400">({{ number_format($company->average_rating, 1) }})</span>
                                    </div>
                                @endif
                                <p class="text-gray-600 dark:text-gray-300 text-xs mb-2 line-clamp-2 flex-grow" title="{{ strip_tags($company->description ?? '') }}">{{ Str::limit(strip_tags($company->description ?? ''), 70) }}</p>
                                <div class="mt-auto text-xs text-gray-500 dark:text-gray-400 flex items-center">
                                    <i class="fas fa-map-marker-alt mr-1 text-gray-400 dark:text-gray-500"></i>
                                    <span>{{ $company->city ?? 'N/A' }}{{ $company->state_province ? ', ' . $company->state_province : '' }}</span>
                                </div>
                            </div>
                        </a>
                    </div>
                @empty
                    {{-- This part might not be reached if swiper doesn't initialize with no slides --}}
                    <p class="col-span-full text-center text-gray-500 dark:text-gray-400">No featured companies available at the moment.</p>
                @endforelse
            </div>
            <div class="swiper-pagination-companies mt-8 text-center"></div> {{-- Add pagination div --}}
        </div>

        @if($companies->count() > 0)
        <div class="text-center mt-12">
            <a href="{{ active_public_route_url('companies.index') }}"
               class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-8 rounded-lg text-lg shadow-md hover:shadow-lg transition-all duration-300">
                Browse All Companies
            </a>
        </div>
        @endif
    </div>
</section>

@push('scripts')
@if($companies->isNotEmpty())
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (document.querySelector('.swiper-container-companies .swiper-slide')) {
            var companiesSwiper = new Swiper('.swiper-container-companies', {
                loop: {{ $companies->count() > 3 ? 'true' : 'false' }}, // Adjust based on slidesPerView
                slidesPerView: 1,
                spaceBetween: 30,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: '.swiper-pagination-companies',
                    clickable: true,
                },
                breakpoints: {
                    640: {
                        slidesPerView: 2,
                        spaceBetween: 20,
                    },
                    1024: {
                        slidesPerView: 3,
                        spaceBetween: 30,
                    }
                }
            });
        }
    });
</script>
@endif
@endpush
