<x-app-layout>
    @section('title', __('My Job Postings - ') . ($company->name ?? __('Your Company')))

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <div>
                <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                    {{ __('My Job Postings') }}
                </h2>
                @if($company)
                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Managing jobs for: {{ $company->name }}</p>
                @endif
            </div>
            <a href="{{ route('frontend.businessdirectory.my_jobs.create') }}"
               class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-white capitalize transition-colors duration-300 transform bg-blue-600 rounded-md hover:bg-blue-500 focus:outline-none focus:ring focus:ring-blue-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-plus mr-2"></i> {{ __('Post New Job') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Session messages are handled by app.blade.php --}}

            {{-- Search and Filter Form --}}
            <form method="GET" action="{{ route('frontend.businessdirectory.my_jobs') }}" class="mb-8 p-6 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                    <div>
                        <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Search by Job Title</label>
                        <input type="text" name="search" id="search" value="{{ request('search') }}"
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                               placeholder="e.g., Senior Developer">
                    </div>
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                        <select name="status" id="status"
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                            <option value="">All Statuses</option>
                             @php
                                $jobPostStatuses = \Modules\BusinessDirectory\Entities\Job::getStatuses(); // Assuming you have a getStatuses method
                            @endphp
                            @foreach($jobPostStatuses as $key => $value)
                                <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <button type="submit"
                                class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Filter Jobs
                        </button>
                    </div>
                </div>
            </form>

            @if($jobs->isNotEmpty())
                <div class="overflow-x-auto bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Title</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Applicants</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Posted</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Deadline</th>
                                <th scope="col" class="relative px-6 py-3"><span class="sr-only">Actions</span></th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @foreach($jobs as $job)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <a href="{{ active_public_route_url('jobs.show', ['slug' => $job->slug]) }}" target="_blank" class="text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 hover:underline" title="View public listing">
                                            {{ $job->title }}
                                        </a>
                                        <div class="text-xs text-gray-500 dark:text-gray-400">{{ $job->location ?? 'N/A' }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @php
                                            $statusClass = 'bg-gray-200 text-gray-700 dark:bg-gray-700 dark:text-gray-100';
                                            if ($job->status === 'open') $statusClass = 'bg-green-100 text-green-700 dark:bg-green-700 dark:text-green-100';
                                            elseif ($job->status === 'closed' || $job->status === 'filled') $statusClass = 'bg-red-100 text-red-700 dark:bg-red-700 dark:text-red-100';
                                            elseif ($job->status === 'draft') $statusClass = 'bg-yellow-100 text-yellow-700 dark:bg-yellow-700 dark:text-yellow-100';
                                        @endphp
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusClass }}">
                                            {{ Str::title(str_replace('_', ' ', $job->status)) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $job->job_applications_count ?? $job->jobApplications()->count() }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $job->created_at->format('M d, Y') }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $job->application_deadline ? $job->application_deadline->format('M d, Y') : 'N/A' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-3">
                                        <a href="{{ route('frontend.businessdirectory.my_jobs.edit', $job->id) }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300">Edit</a>
                                        {{-- Add delete form if needed --}}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @if($jobs->hasPages())
                <div class="mt-6">
                    {{ $jobs->appends(request()->query())->links() }}
                </div>
                @endif
            @else
                <div class="text-center py-12 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                    <i class="fas fa-briefcase fa-3x text-gray-400 dark:text-gray-500 mb-3"></i>
                    <p class="text-xl text-gray-600 dark:text-gray-300">You haven't posted any jobs yet.</p>
                    <a href="{{ route('frontend.businessdirectory.my_jobs.create') }}" class="mt-4 inline-block bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md">Post Your First Job</a>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>