<x-app-layout>
    @section('title', __('Edit Job: ') . $job->title)

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <div>
                <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                    {{ __('Edit Job Posting') }}
                </h2>
                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                    <span class="font-medium">{{ $job->title }}</span> - For company: {{ $company->name ?? 'N/A' }}
                </p>
            </div>
            <a href="{{ route('frontend.businessdirectory.my_jobs') }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-gray-700 dark:text-gray-300 capitalize transition-colors duration-300 transform bg-gray-200 dark:bg-gray-700 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> {{ __('Back to My Jobs') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-3xl mx-auto bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6 md:p-8">
                <form action="{{ route('frontend.businessdirectory.my_jobs.update', $job->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    @include('businessdirectory::frontend.jobs._my_job_form', [
                        'job' => $job,
                        'company' => $company, // Pass the company variable
                        'job_types' => $job_types,
                        'job_statuses' => $job_statuses,
                        'isEdit' => true // Explicitly set for clarity
                    ])
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
