{{--
    This partial expects:
    - $job: The job model instance (new Job() for create, existing for edit)
    - $company: The company this job belongs to.
    - $job_statuses: Array of available job statuses for the form.
    - $job_types: Array of available job types for the form.
    - $isEdit: (Optional) boolean, true if editing, defaults to false.
--}}
<div class="space-y-6">
    <div>
        <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Job Title <span class="text-red-500">*</span></label>
        <input type="text" name="title" id="title" value="{{ old('title', $job->title ?? '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('title') border-red-500 @enderror">
        @error('title') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <input type="hidden" name="company_id" value="{{ $company->id }}">

    <div>
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Job Description <span class="text-red-500">*</span></label>
        <textarea name="description" id="description" rows="8" required
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('description') border-red-500 @enderror">{{ old('description', $job->description ?? '') }}</textarea>
        @error('description') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="job_type" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Job Type</label>
            <select name="job_type" id="job_type"
                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md @error('job_type') border-red-500 @enderror">
                <option value="">Select Type</option>
                @foreach($job_types as $key => $value)
                    <option value="{{ $key }}" {{ (old('job_type', $job->job_type ?? '') == $key) ? 'selected' : '' }}>{{ $value }}</option>
                @endforeach
            </select>
            @error('job_type') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="location" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Location (e.g., City, State or "Remote")</label>
            <input type="text" name="location" id="location" value="{{ old('location', $job->location ?? '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('location') border-red-500 @enderror">
            @error('location') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>

    <div>
        <label for="application_deadline" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Application Deadline (Optional)</label>
        <input type="date" name="application_deadline" id="application_deadline" value="{{ old('application_deadline', isset($job->application_deadline) ? $job->application_deadline->format('Y-m-d') : '') }}"
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('application_deadline') border-red-500 @enderror">
        @error('application_deadline') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="skills_required" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Skills Required (Comma-separated)</label>
        <input type="text" name="skills_required" id="skills_required" value="{{ old('skills_required', is_array($job->skills_required ?? '') ? implode(', ', $job->skills_required) : ($job->skills_required ?? '')) }}"
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('skills_required') border-red-500 @enderror">
        @error('skills_required') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="flex items-center">
        <input id="is_remote" name="is_remote" type="checkbox" value="1" {{ old('is_remote', $job->is_remote ?? false) ? 'checked' : '' }}
               class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded focus:ring-indigo-500">
        <label for="is_remote" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">This is a remote position</label>
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
        <select name="status" id="status" required
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md @error('status') border-red-500 @enderror">
            @foreach($job_statuses as $key => $value)
                <option value="{{ $key }}" {{ (old('status', $job->status ?? 'draft') == $key) ? 'selected' : '' }}>{{ $value }}</option>
            @endforeach
        </select>
        @error('status') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    {{-- Attachments Section --}}
    <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-gray-100">Attachments</h3>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Upload any relevant documents (PDF, DOC, DOCX, JPG, PNG). Max 2MB per file.</p>

        @if(($isEdit ?? false) && $job->attachments->isNotEmpty())
            <div class="mt-4">
                <h4 class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Current Attachments:</h4>
                <ul class="list-disc list-inside space-y-1">
                    @foreach($job->attachments as $attachment)
                        <li class="text-sm text-gray-600 dark:text-gray-400">
                            <a href="{{ $attachment->url }}" target="_blank" class="text-indigo-600 dark:text-indigo-400 hover:underline">{{ $attachment->original_name }}</a>
                            ({{ $attachment->readable_size }})
                            {{-- TODO: Implement Delete Attachment Functionality --}}
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="mt-4">
            <label for="attachments" class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ ($isEdit ?? false) ? 'Add More Attachments' : 'Upload Attachments' }}</label>
            <input type="file" name="attachments[]" id="attachments" multiple
                   class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-400
                          file:mr-4 file:py-2 file:px-4
                          file:rounded-md file:border-0
                          file:text-sm file:font-semibold
                          file:bg-indigo-50 dark:file:bg-indigo-800 file:text-indigo-700 dark:file:text-indigo-200
                          hover:file:bg-indigo-100 dark:hover:file:bg-indigo-700
                          @error('attachments') border-red-500 @enderror @error('attachments.*') border-red-500 @enderror">
            @error('attachments') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            @error('attachments.*') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>

    <div class="pt-8">
        <div class="flex justify-end space-x-3">
            <a href="{{ route('frontend.businessdirectory.my_jobs') }}"
               class="bg-white dark:bg-gray-700 py-2 px-4 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Cancel
            </a>
            <button type="submit"
                    class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800">
                {{ ($isEdit ?? false) ? 'Update Job' : 'Post Job' }}
            </button>
        </div>
    </div>
</div>