@extends('layouts.frontend') {{-- Use the module's frontend layout --}}

@section('title', $pageTitle ?? setting('site_name'))
@section('meta_description', $metaDescription ?? '')
@section('meta_keywords', $metaKeywords ?? '')

@section('content') {{-- Wrap content in a section --}}
    {{-- Hero Slideshow Section - Full Width --}}
    @include('businessdirectory::frontend.partials._hero_feature_slider', [
        'companyTypes' => $companyTypes ?? collect() // Pass companyTypes if needed for a global search in hero
    ])

    {{-- Features Icon Slider --}}
    @include('businessdirectory::frontend.partials._features_icon_slider')

    {{-- Main Content and Sidebar Area --}}
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="flex flex-col lg:flex-row lg:space-x-8">
            {{-- Sidebar --}}
            {{-- Adjusted top value: h-16 (header) + py-2 (topbar) = 64px + 8px = 72px. Add a bit for spacing/shadows.
                 Let's use a slightly larger value like 88px (top-22) to ensure it clears the sticky header and top bar.
                 The sidebar's internal height is calc(100vh - 100px), so this should work. --}}
            <aside class="lg:w-1/3 lg:sticky lg:top-[88px] self-start">
                @include('businessdirectory::frontend.partials._sidebar_directory_navigator')
            </aside>

            {{-- Main Content Area --}}
            <div class="lg:w-2/3 space-y-12 mt-8 lg:mt-0">
                {{-- Featured Companies Section --}}
                @if($featuredCompanies->isNotEmpty())
                    @include('businessdirectory::frontend.partials._featured_companies_section', ['companies' => $featuredCompanies])
                @endif

                {{-- Featured Products Section --}}
                @if($featuredProducts->isNotEmpty())
                    @include('businessdirectory::frontend.partials._featured_products_section', ['products' => $featuredProducts])
                @endif

                {{-- Latest Tenders & Jobs Section --}}
                @if($latestTenders->isNotEmpty() || $latestJobs->isNotEmpty())
                    @include('businessdirectory::frontend.partials._latest_tenders_and_jobs_section', ['tenders' => $latestTenders, 'jobs' => $latestJobs])
                @endif

                {{-- How It Works Section --}}
                @include('businessdirectory::frontend.partials._how_it_works_section')

                {{-- Newsletter Section --}}
                @include('businessdirectory::frontend.partials._newsletter_section')

                {{-- Testimonials Section (Placeholder) --}}
                @include('businessdirectory::frontend.partials._testimonials_section')

                {{-- Platform Features Section --}}
                @include('businessdirectory::frontend.partials._platform_features_section')

                {{-- Contact Us Section --}}
                @include('businessdirectory::frontend.partials._contact_us_section')
            </div>
        </div>
    </div>
@endsection
