@extends('layouts.app') {{-- Or your main frontend layout --}}

@section('title', 'Company Types - ' . setting('site_name', 'Digital Vocano'))

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-6">Browse Company Types</h1>

    @if($companyTypes->isEmpty())
        <p class="text-gray-600 dark:text-gray-400">No company types found at the moment.</p>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($companyTypes as $type)
                <a href="{{ route('public.businessdirectory.companies.by_type', $type->slug) }}"
                   class="block p-6 bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                    <h2 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-2">{{ $type->name }}</h2>
                    @if($type->description)
                        <p class="text-gray-600 dark:text-gray-400 text-sm">{{ Str::limit($type->description, 100) }}</p>
                    @endif
                    {{-- You could add a count of companies in this type later --}}
                </a>
            @endforeach
        </div>

        <div class="mt-8">
            {{ $companyTypes->links() }}
        </div>
    @endif
</div>
@endsection