@extends('layouts.frontend')

@section('title', $company->meta_title ?: $company->name)
@section('meta_description', $company->meta_description ?: Str::limit(strip_tags($company->description), 160))
@section('meta_keywords', $company->meta_keywords ?: ($company->name . ', ' . ($company->companyType->name ?? '') . ', ' . $company->city . ', ' . $company->state_province))

@section('content')
<div class="bg-gray-100 dark:bg-gray-900">
    <!-- Banner and Header Section -->
    <section class="relative"> {{-- Assuming banner_url_public accessor and hasCustomBanner() method in Company model --}}
        @if($company->hasCustomBanner())
            <img src="{{ $company->banner_url_public }}" alt="{{ $company->name }} banner" class="w-full h-64 md:h-80 lg:h-96 object-cover">
            <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-black/30 to-transparent"></div>
        @else
            <div class="w-full h-64 md:h-80 lg:h-96 bg-gradient-to-br from-slate-400 to-slate-600 dark:from-slate-700 dark:to-slate-800 flex items-center justify-center">
                {{-- Placeholder if no banner --}}
            </div>
        @endif

        <div class="absolute bottom-0 left-0 right-0 px-4 sm:px-6 lg:px-8 pb-6 md:pb-8">
            <div class="container mx-auto">
                <div class="flex flex-col md:flex-row items-end space-x-0 md:space-x-6">
                    @if($company->hasCustomLogo()) {{-- Assuming logo_url_public accessor and hasCustomLogo() method --}}
                        <img src="{{ $company->logo_url_public }}" alt="{{ $company->name }} logo" class="w-28 h-28 md:w-36 md:h-36 object-contain rounded-lg bg-white dark:bg-gray-700 p-1 border-4 border-white dark:border-gray-600 shadow-xl -mb-10 md:-mb-12 relative z-10">
                    @else
                        <div class="flex items-center justify-center w-28 h-28 md:w-36 md:h-36 object-contain rounded-lg bg-gray-200 dark:bg-gray-700 p-1 border-4 border-white dark:border-gray-600 shadow-xl -mb-10 md:-mb-12 relative z-10 text-gray-400 dark:text-gray-500">
                            <i class="fas fa-building text-5xl"></i>
                        </div>
                    @endif
                    <div class="mt-4 md:mt-0 md:pb-2 relative z-0">
                        <h1 class="text-3xl md:text-4xl font-bold text-white drop-shadow-lg">{{ $company->name }}</h1>
                        <p class="text-md text-gray-200 dark:text-gray-300 drop-shadow-sm">{{ $company->companyType->name ?? 'Business' }}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Main Content Area with Sidebar -->
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8 md:py-12">
        <div class="flex flex-col lg:flex-row lg:space-x-8">
            <!-- Main Content Column -->
            <div class="lg:w-2/3 space-y-8">
                <!-- About Section -->
                <section class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">About {{ $company->name }}</h2>
                    <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                        {!! nl2br(e($company->description)) !!}
                    </div>
                    @if($company->established_date || $company->employee_count)
                    <div class="mt-6 grid grid-cols-1 sm:grid-cols-2 gap-4 text-sm">
                        @if($company->established_date)
                        <div>
                            <strong class="text-gray-600 dark:text-gray-400">Established:</strong>
                            <span class="text-gray-800 dark:text-gray-200">{{ $company->established_date->format('Y') }}</span>
                        </div>
                        @endif
                        @if($company->employee_count)
                        <div>
                            <strong class="text-gray-600 dark:text-gray-400">Employees:</strong>
                            <span class="text-gray-800 dark:text-gray-200">{{ $company->employee_count }}</span>
                        </div>
                        @endif
                    </div>
                    @endif
                </section>

                <!-- Products Section -->
                @if($company->is_ecommerce && $company->products->isNotEmpty())
                <section class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Our Products</h2>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach($company->products as $product)
                            @include('businessdirectory::frontend.partials._product_card_minimal', ['product' => $product])
                        @endforeach
                    </div>
                    @if($company->products()->published()->count() > $company->products->count()) {{-- Check if there are more products than currently loaded --}}
                        <div class="mt-6 text-center">
                        {{-- Ensure active_public_route_url maps 'companies.products.index' to 'theme.company.products' and handles 'company_slug' param when LandingPage is active --}}
                        <a href="{{ active_public_route_url('companies.products.index', ['company_slug' => $company->slug]) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline font-semibold">
                                View All Products ({{ $company->products()->published()->count() }}) <i class="fas fa-arrow-right text-xs ml-1"></i>
                            </a>
                        </div>
                    @endif
                </section>
                @endif

                <!-- Jobs Section -->
                @if($company->relationLoaded('jobs') && $company->jobs->isNotEmpty())
                <section class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Open Positions</h2>
                    <div class="space-y-4">
                        @foreach($company->jobs as $job)
                            @include('businessdirectory::frontend.partials._job_card_minimal', ['job' => $job])
                        @endforeach
                    </div>
                    @if($company->jobs()->open()->count() > $company->jobs->count())
                        <div class="mt-6 text-center">
                            <a href="{{-- active_public_route_url('companies.jobs.index', ['company' => $company->slug]) --}}" class="text-indigo-600 dark:text-indigo-400 hover:underline font-semibold">
                                View All Open Positions ({{ $company->jobs()->open()->count() }}) <i class="fas fa-arrow-right text-xs ml-1"></i>
                            </a>
                        </div>
                    @endif
                </section>
                @endif

                <!-- Tenders Section -->
                @php
                    // Eager load open tenders if not already loaded, or filter if already loaded
                    // This assumes 'tenders' relation might be loaded with all tenders,
                    // so we filter for open ones for display here.
                    // If 'tenders' is always meant to be open tenders, this can be simplified.
                    $openTenders = $company->relationLoaded('tenders') ?
                                   $company->tenders->where('status', 'open')->where('deadline', '>=', now()) :
                                   $company->tenders()->open()->get();
                    $totalOpenTendersCount = $company->tenders()->open()->count();
                @endphp
                @if($openTenders->isNotEmpty())
                <section class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Active Tenders</h2>
                    <div class="space-y-4">
                        @foreach($openTenders->take(3) as $tender) {{-- Show a few initially --}}
                            @include('businessdirectory::frontend.partials._tender_card_minimal', ['tender' => $tender])
                        @endforeach
                    </div>
                     @if($totalOpenTendersCount > $openTenders->take(3)->count())
                        <div class="mt-6 text-center">
                        {{-- Ensure active_public_route_url maps 'companies.tenders.index' to 'theme.company.tenders' and handles 'company_slug' param --}}
                        <a href="{{ active_public_route_url('companies.tenders.index', ['company_slug' => $company->slug]) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline font-semibold">
                                View All Active Tenders ({{ $totalOpenTendersCount }}) <i class="fas fa-arrow-right text-xs ml-1"></i>
                            </a>
                        </div>
                    @endif
                </section>
                @endif

                <!-- Reviews Section -->
                <section id="reviews" class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Reviews ({{ $reviewCount }})</h2>
                    @if($averageRating > 0)
                        <div class="mb-4 flex items-center">
                            <span class="text-yellow-400 text-xl">
                                @for ($i = 1; $i <= 5; $i++)
                                    <i class="fas fa-star{{ $i <= round($averageRating) ? '' : ($i - 0.5 <= $averageRating ? '-half-alt' : ' far fa-star') }}"></i>
                                @endfor
                            </span>
                            <span class="ml-2 text-gray-600 dark:text-gray-400">({{ number_format($averageRating, 1) }} out of 5)</span>
                        </div>
                    @endif

                    <div class="space-y-6">
                        @forelse($company->reviews as $review)
                            <article class="p-4 border border-gray-200 dark:border-gray-700 rounded-md">
                                <div class="flex items-center mb-2">
                                    {{-- User Avatar Placeholder --}}
                                    <span class="w-8 h-8 rounded-full bg-gray-300 dark:bg-gray-600 text-gray-600 dark:text-gray-300 flex items-center justify-center text-sm font-semibold mr-3">
                                        {{ strtoupper(substr($review->user->name ?? 'A', 0, 1)) }}
                                    </span>
                                    <div>
                                        <p class="font-semibold text-gray-800 dark:text-white">{{ $review->user->name ?? 'Anonymous' }}</p>
                                        <div class="text-xs text-yellow-400">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <i class="fas fa-star{{ $i <= $review->rating ? '' : ' far fa-star' }}"></i>
                                            @endfor
                                        </div>
                                    </div>
                                    <time datetime="{{ $review->created_at->toIso8601String() }}" class="ml-auto text-xs text-gray-500 dark:text-gray-400">{{ $review->created_at->format('M d, Y') }}</time>
                                </div>
                                @if($review->title)
                                <h4 class="font-medium text-gray-700 dark:text-gray-300 mb-1">{{ $review->title }}</h4>
                                @endif
                                <p class="text-sm text-gray-600 dark:text-gray-400 whitespace-pre-wrap">{{ $review->comment }}</p>
                            </article>
                        @empty
                            <p class="text-gray-600 dark:text-gray-400">No reviews yet for this company. Be the first to write one!</p>
                        @endforelse
                    </div>

                    @auth
                        <div id="submit-review-form" class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                            <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-3">Write a Review</h3>
                            <form action="{{ route('frontend.businessdirectory.companies.reviews.store', $company->slug) }}" method="POST">
                                @csrf
                                <div class="mb-4">
                                    <label for="rating" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Your Rating <span class="text-red-500">*</span></label>
                                    <select name="rating" id="rating" required class="mt-1 form-select block w-full sm:w-auto dark:bg-gray-700 dark:border-gray-600 rounded-md">
                                        <option value="">Select rating</option>
                                        @for ($i = 5; $i >= 1; $i--)
                                            <option value="{{ $i }}">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <div class="mb-4">
                                    <label for="review_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Review Title (Optional)</label>
                                    <input type="text" name="title" id="review_title" class="mt-1 form-input block w-full dark:bg-gray-700 dark:border-gray-600 rounded-md">
                                </div>
                                <div class="mb-4">
                                    <label for="comment" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Your Review <span class="text-red-500">*</span></label>
                                    <textarea name="comment" id="comment" rows="4" required class="mt-1 form-textarea block w-full dark:bg-gray-700 dark:border-gray-600 rounded-md"></textarea>
                                </div>
                                <button type="submit" class="inline-flex items-center px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white font-semibold rounded-md shadow-sm">Submit Review</button>
                            </form>
                        </div>
                    @else
                        <p class="mt-6 text-sm text-gray-600 dark:text-gray-400">
                            <a href="{{ route('login') }}?redirect={{ url()->current() }}#submit-review-form" class="text-indigo-600 hover:underline">Login</a> or
                            <a href="{{ route('register') }}?redirect={{ url()->current() }}#submit-review-form" class="text-indigo-600 hover:underline">register</a> to write a review.
                        </p>
                    @endauth
                </section>
            </div>

            <!-- Sidebar Column -->
            <aside class="lg:w-1/3 mt-8 lg:mt-0 space-y-6">
                <!-- Contact & Info Card -->
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6">
                    <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Contact & Info</h3>
                    <ul class="space-y-3 text-sm text-gray-700 dark:text-gray-300">
                        @if($company->address_line_1)
                            <li class="flex items-start">
                                <i class="fas fa-map-marker-alt fa-fw mt-1 mr-3 text-gray-400 dark:text-gray-500"></i>
                                <span>{{ $company->address_line_1 }}{{ $company->address_line_2 ? ', ' . $company->address_line_2 : '' }}<br>{{ $company->city }}, {{ $company->state_province }} {{ $company->postal_code }}<br>{{ $company->country_code }}</span>
                            </li>
                        @endif
                        @if($company->phone_number)
                            <li class="flex items-center">
                                <i class="fas fa-phone-alt fa-fw mr-3 text-gray-400 dark:text-gray-500"></i>
                                <a href="tel:{{$company->phone_number}}" class="hover:text-indigo-600 dark:hover:text-indigo-400">{{ $company->phone_number }}</a>
                            </li>
                        @endif
                        @if($company->email)
                            <li class="flex items-center">
                                <i class="fas fa-envelope fa-fw mr-3 text-gray-400 dark:text-gray-500"></i>
                                <a href="mailto:{{ $company->email }}" class="hover:text-indigo-600 dark:hover:text-indigo-400">{{ $company->email }}</a>
                            </li>
                        @endif
                        @if($company->website_url)
                            <li class="flex items-center">
                                <i class="fas fa-globe fa-fw mr-3 text-gray-400 dark:text-gray-500"></i>
                                <a href="{{ $company->website_url }}" target="_blank" rel="noopener noreferrer" class="hover:text-indigo-600 dark:hover:text-indigo-400 truncate">{{ $company->website_url }}</a>
                            </li>
                        @endif
                    </ul>
                    @if($company->social_links && count(array_filter($company->social_links)) > 0)
                        <div class="mt-4 pt-3 border-t dark:border-gray-700">
                            <p class="text-sm font-medium text-gray-600 dark:text-gray-400 mb-2">Follow us:</p>
                            <div class="flex space-x-3">
                                @foreach(array_filter($company->social_links) as $platform => $link)
                                    <a href="{{ $link }}" target="_blank" rel="noopener noreferrer" class="text-gray-400 hover:text-{{ str_replace(['facebook-f', 'linkedin-in', 'twitter-x'], ['facebook', 'linkedin', 'gray'], $platform) }}-500 dark:hover:text-{{ str_replace(['facebook-f', 'linkedin-in', 'twitter-x'], ['facebook', 'linkedin', 'gray'], $platform) }}-300 text-xl" title="{{ ucfirst($platform) }}">
                                        <i class="fab fa-{{ $platform == 'twitter' ? 'twitter-x' : ($platform == 'facebook' ? 'facebook-f' : $platform) }}"></i>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>

                <!-- Map Card -->
                @if($company->latitude && $company->longitude)
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6">
                    <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Location Map</h3>
                    <div id="company-map" style="height: 250px;" class="rounded-md border dark:border-gray-700"></div>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1 text-center">Map data &copy; <a href="https://www.openstreetmap.org/copyright" class="underline" target="_blank">OpenStreetMap</a> contributors</p>
                </div>
                @endif

                {{-- You can add other sidebar widgets here, e.g., similar companies, ads --}}
            </aside>
        </div>
    </div>
</div>

<!-- WhatsApp Floating Widget -->
@if($company->whatsapp_number)
    @php
        $rawWhatsappNumber = trim($company->whatsapp_number ?? '');
        $formattedWhatsappNumber = '';

        if (str_starts_with($rawWhatsappNumber, '+')) {
            // Already in international format, just strip non-digits except the leading '+'
            $formattedWhatsappNumber = '+' . preg_replace('/[^0-9]/', '', substr($rawWhatsappNumber, 1));
        } else {
            // Not starting with '+', so attempt to apply country prefix
            $digitsOnlyNumber = preg_replace('/[^0-9]/', '', $rawWhatsappNumber);
            $countryCode = strtoupper($company->country_code ?? '');
            $internationalPrefix = null;

            // Expand this map with more country codes relevant to your users
            $countryPrefixMap = [
                'ZW' => '263', 'ZA' => '27', 'US' => '1',  'GB' => '44', 'AU' => '61',
                'KE' => '254', 'NG' => '234', 'TZ' => '255', 'UG' => '256', 'CA' => '1',
                'IN' => '91',  'PK' => '92', 'BD' => '880', 'AE' => '971', 'SA' => '966',
                'MW' => '265', 'ZM' => '260', 'BW' => '267', 'MZ' => '258',
                // Add more here...
            ];

            if (array_key_exists($countryCode, $countryPrefixMap)) {
                $internationalPrefix = $countryPrefixMap[$countryCode];
            }

            if ($internationalPrefix) {
                // Remove common local leading zero if present
                $nationalNumber = $digitsOnlyNumber;
                if (str_starts_with($nationalNumber, '0')) {
                    $nationalNumber = substr($nationalNumber, 1);
                }

                // Check if the number (after stripping leading '0') already starts with the prefix
                if (!str_starts_with($nationalNumber, $internationalPrefix)) {
                    $formattedWhatsappNumber = $internationalPrefix . $nationalNumber;
                } else {
                    // It seems the prefix was already there (e.g., user entered 2637... instead of 07...)
                    $formattedWhatsappNumber = $nationalNumber;
                }
            } else {
                // No prefix found for the country code, or no country code provided. Use digits only.
                // This might not work reliably for wa.me if not globally unique.
                $formattedWhatsappNumber = $digitsOnlyNumber;
            }
        }
        $whatsappMessage = urlencode('Hello ' . $company->name . ', I found your profile on ' . setting('site_name', config('app.name')) . ' and I would like to inquire about...');
    @endphp
    <a href="https://wa.me/{{ $formattedWhatsappNumber }}?text={{ $whatsappMessage }}"
       target="_blank" rel="noopener noreferrer" title="Chat with {{ $company->name }} on WhatsApp"
       class="fixed bottom-6 right-6 z-50 bg-green-500 hover:bg-green-600 text-white p-4 rounded-full shadow-xl transition-transform duration-300 hover:scale-110 focus:outline-none focus:ring-2 focus:ring-green-400 focus:ring-offset-2"
       aria-label="Chat with {{ $company->name }} on WhatsApp">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" viewBox="0 0 24 24" fill="currentColor"><path d="M.057 24l1.687-6.163c-1.041-1.804-1.588-3.849-1.587-5.946.003-6.556 5.338-11.891 11.893-11.891 3.181.001 6.167 1.24 8.413 3.488 2.245 2.248 3.487 5.235 3.487 8.413 0 6.557-5.338 11.892-11.893 11.892-1.99-.001-3.951-.5-5.688-1.448l-6.305 1.654zm6.597-3.807c1.676.995 3.276 1.591 5.392 1.592 5.448 0 9.886-4.434 9.889-9.885.002-5.462-4.415-9.89-9.881-9.892-5.452 0-9.887 4.434-9.889 9.884-.001 2.225.651 3.891 1.746 5.634l-.999 3.648 3.742-.981zm11.387-5.464c-.074-.124-.272-.198-.57-.347-.297-.149-1.758-.868-2.031-.967-.272-.099-.47-.149-.669.149-.198.297-.768.967-.941 1.165-.173.198-.347.223-.644.074-.297-.149-1.255-.462-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.297-.347.446-.521.151-.172.2-.296.3-.495.099-.198.05-.372-.025-.521-.075-.148-.669-1.611-.916-2.206-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01s-.521.074-.792.372c-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.626.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.695.248-1.289.173-1.413z"/></svg>
    </a>
@endif

@push('styles')
@if($company->latitude && $company->longitude)
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
@endif
@endpush

@if($company->latitude && $company->longitude)
@push('scripts')
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            if (document.getElementById('company-map')) {
                const lat = parseFloat("{{ $company->latitude }}");
                const lng = parseFloat("{{ $company->longitude }}");
                const companyName = "{{ addslashes($company->name) }}"; // Escape company name for JS

                var map = L.map('company-map').setView([lat, lng], 15); // Zoom level 15
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    maxZoom: 19,
                    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap</a> contributors'
                }).addTo(map);
                L.marker([lat, lng]).addTo(map)
                    .bindPopup(`<b>${companyName}</b><br>{{ addslashes($company->address_line_1 ?? '') }}`)
                    .openPopup();
            }
        });
    </script>
@endpush
@endif

@push('schema_markup')
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "{{ $company->companyType && str_contains(strtolower($company->companyType->name), 'retail') ? 'Store' : ($company->companyType && str_contains(strtolower($company->companyType->name), 'service') ? 'ProfessionalService' : 'LocalBusiness') }}",
    "name": "{{ addslashes($company->name) }}",
    "description": "{{ addslashes(Str::limit(strip_tags($company->description), 250)) }}",
    "url": "{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}",
    @if($company->logo_url && $company->logo_url !== asset('path/to/default-logo.png'))
    "logo": "{{ $company->logo_url }}",
    "image": "{{ $company->logo_url }}",
    @elseif($company->banner_url && $company->banner_url !== asset('path/to/default-banner.png'))
    "image": "{{ $company->banner_url }}",
    @endif
    @if($company->phone_number)
    "telephone": "{{ $company->phone_number }}",
    @endif
    @if($company->email)
    "email": "{{ $company->email }}",
    @endif
    @if($company->address_line_1 && $company->city && $company->country_code)
    "address": {
        "@type": "PostalAddress",
        "streetAddress": "{{ addslashes($company->address_line_1 . ($company->address_line_2 ? ', ' . $company->address_line_2 : '')) }}",
        "addressLocality": "{{ addslashes($company->city) }}",
        @if($company->state_province)
        "addressRegion": "{{ addslashes($company->state_province) }}",
        @endif
        @if($company->postal_code)
        "postalCode": "{{ addslashes($company->postal_code) }}",
        @endif
        "addressCountry": "{{ strtoupper($company->country_code) }}"
    },
    @endif
    @if($company->latitude && $company->longitude)
    "geo": {
        "@type": "GeoCoordinates",
        "latitude": "{{ $company->latitude }}",
        "longitude": "{{ $company->longitude }}"
    },
    @endif
    @php
        $sameAsLinks = [];
        if ($company->website_url) $sameAsLinks[] = $company->website_url;
        if (is_array($company->social_links)) { // Ensure social_links is an array
            $sameAsLinks = array_merge($sameAsLinks, array_values(array_filter($company->social_links)));
        }
    @endphp
    @if(!empty($sameAsLinks))
    "sameAs": [
        @foreach($sameAsLinks as $link)"{{ $link }}"@if(!$loop->last),@endif @endforeach
    ],
    @endif
    @if($averageRating > 0 && $reviewCount > 0)
    "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "{{ number_format($averageRating, 1) }}",
        "reviewCount": "{{ $reviewCount }}"
    },
    @endif
    @if($company->reviews->isNotEmpty())
    "review": [
        @foreach($company->reviews as $review)
        {
            "@type": "Review",
            "author": {
                "@type": "Person",
                "name": "{{ addslashes($review->user->name ?? 'Anonymous') }}"
            },
            "datePublished": "{{ $review->created_at->toIso8601String() }}",
            @if($review->title)
            "name": "{{ addslashes($review->title) }}",
            @endif
            "reviewBody": "{{ addslashes($review->comment) }}",
            "reviewRating": {
                "@type": "Rating",
                "ratingValue": "{{ $review->rating }}"
            }
        } @if(!$loop->last),@endif
        @endforeach
    ]
    @endif
}
</script>
@endpush
@endsection
