@extends('layouts.frontend')

    @section('title', $pageTitle ?? __('Company Directory'))
    @section('meta_description', $metaDescription ?? __('Browse our directory of companies.'))

@section('content')
    @include('businessdirectory::frontend.partials._page_hero_search', [
        'title' => $pageTitle ?? __('Company Directory'),
        'subtitle' => $metaDescription ?? __('Find trusted businesses and service providers.'),
        'searchActionRoute' => active_public_route_url('companies.index'),
        'searchPlaceholder' => 'Search by company name, industry, location...',
        'showFilters' => true, // Set to true to show the "Advanced Filters" button
        'filterTargetId' => 'company-filters' // ID of the filter section below
    ])

    <div class="py-12" id="company-filters">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Search/Filter Form -->
            <div class="mb-8 p-4 bg-white dark:bg-gray-800 shadow rounded-lg">
                <form method="GET" action="{{ active_public_route_url('companies.index') }}" class="space-y-4 md:space-y-0 md:flex md:space-x-4 md:items-end">
                    <div class="flex-grow md:flex md:space-x-4"> {{-- Make this a flex container on md+ screens --}}
                        <div class="flex-grow mb-4 md:mb-0"> {{-- Input takes available space, add bottom margin for mobile stacking --}}
                            <label for="search" class="sr-only">Search Companies</label>
                            <input type="text" name="search" id="search" value="{{ request('search') }}" placeholder="Company name, city..." class="form-input w-full dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 rounded-md">
                        </div>
                        <div class="w-full md:w-auto md:min-w-[200px]"> {{-- Select takes its content width or a specific min-width on md+ --}}
                            <label for="company_type_slug" class="sr-only">Industry</label>
                            <select name="company_type_slug" id="company_type_slug" class="form-select w-full dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 rounded-md">
                                <option value="">All Industries</option>
                                @foreach($companyTypes ?? [] as $type)
                                    <option value="{{ $type->slug }}" {{ request('company_type_slug') == $type->slug ? 'selected' : '' }}>{{ $type->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="flex-shrink-0">
                        <div>
                            <label for="submit_comp_filter" class="sr-only">Search</label>
                            <button type="submit" id="submit_comp_filter" class="w-full md:w-auto px-4 py-2 text-sm font-medium tracking-wide text-white capitalize transition-colors duration-300 transform bg-blue-600 rounded-md hover:bg-blue-500 focus:outline-none focus:ring focus:ring-blue-300 focus:ring-opacity-80">
                                <i class="fas fa-search mr-2"></i> Search Companies
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            @if($companies->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    @foreach($companies as $company)
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1 flex flex-col group">
                            <div class="relative"> {{-- Banner and Logo Area --}}
                                <a href="{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}" class="block">
                                    @if($company->hasCustomBanner())
                                    <img src="{{ $company->banner_url_public }}" alt="{{ $company->name }} banner" class="w-full h-40 object-cover transition-transform duration-300 group-hover:scale-105">
                                    @else
                                        <div class="w-full h-40 bg-gradient-to-r from-slate-300 to-slate-400 dark:from-slate-600 dark:to-slate-500 flex items-center justify-center">
                                            <i class="fas fa-image text-5xl text-slate-500 dark:text-slate-400 opacity-70"></i>
                                        </div>
                                    @endif
                                </a>
                                @if($company->hasCustomLogo())
                                <a href="{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}" class="absolute -bottom-8 left-6">
                                    <img class="h-16 w-16 rounded-full object-contain bg-white dark:bg-gray-700 p-1 border-2 border-white dark:border-gray-600 shadow-md" src="{{ $company->logo_url_public }}" alt="{{ $company->name }} logo">
                                    </a>
                                @else
                                    <a href="{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}" class="absolute -bottom-8 left-6 flex items-center justify-center h-16 w-16 rounded-full bg-gray-200 dark:bg-gray-700 border-2 border-white dark:border-gray-600 shadow-md text-gray-400 dark:text-gray-500">
                                        <i class="fas fa-building text-2xl"></i>
                                    </a>
                                @endif
                                @if($company->is_featured)
                                    <span class="absolute top-2 right-2 bg-yellow-400 text-yellow-800 text-xs font-semibold px-2 py-0.5 rounded-full shadow">Featured</span>
                                @endif
                            </div>
                            <div class="p-6 pt-10 flex-grow flex flex-col"> {{-- Content Area --}}
                                <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-1">
                                    <a href="{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}" class="hover:text-indigo-600 dark:hover:text-indigo-400 transition-colors duration-200">
                                        {{ $company->name }}
                                    </a>
                                    @if($company->is_verified)
                                        <span title="Verified Company" class="ml-1 text-green-500 dark:text-green-400"><i class="fas fa-check-circle text-sm"></i></span>
                                    @endif
                                </h3>
                                <p class="text-xs text-purple-600 dark:text-purple-400 font-medium mb-2">{{ $company->companyType->name ?? 'Business' }}</p>

                                @if(isset($company->average_rating) && $company->average_rating > 0)
                                    <div class="text-xs text-yellow-400 mb-2 flex items-center">
                                        @for ($i = 1; $i <= 5; $i++) <i class="fas fa-star{{ $i <= round($company->average_rating) ? '' : ($i - 0.5 <= $company->average_rating ? '-half-alt' : ' far fa-star') }}"></i> @endfor
                                        <span class="ml-1.5 text-gray-500 dark:text-gray-400">({{ number_format($company->average_rating, 1) }})</span>
                                    </div>
                                @endif

                                <p class="text-gray-600 dark:text-gray-300 text-sm mb-3 line-clamp-2 flex-grow" title="{{ strip_tags($company->description) }}">
                                    {{ Str::limit(strip_tags($company->description), 90) }}
                                </p>

                                @if($company->city || $company->state_province)
                                <div class="text-xs text-gray-500 dark:text-gray-400 mb-3 flex items-center">
                                    <i class="fas fa-map-marker-alt mr-1.5 text-gray-400 dark:text-gray-500"></i>
                                    <span>{{ $company->city ?? '' }}{{ ($company->city && $company->state_province) ? ', ' : '' }}{{ $company->state_province ?? '' }}</span>
                                </div>
                                @endif

                                <div class="mt-auto pt-3 border-t border-gray-200 dark:border-gray-700">
                                    <a href="{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}" class="text-sm font-semibold text-indigo-600 dark:text-indigo-400 hover:text-indigo-500 dark:hover:text-indigo-300 transition-colors duration-200">
                                        View Profile <i class="fas fa-arrow-right text-xs ml-1"></i>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="mt-8">
                    {{ $companies->links() }}
                </div>
            @else
                <p class="text-center text-gray-700 dark:text-gray-300 text-lg">No companies found matching your criteria.</p>
            @endif
        </div>
    </div>
@endsection