<x-app-layout>
    @section('title', __('Create New Company'))

    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('List a New Company') }}
            </h2>
            <a href="{{ route('frontend.businessdirectory.my-companies.index') }}"
               class="px-4 py-2 text-sm font-medium tracking-wide text-gray-700 capitalize transition-colors duration-300 transform bg-gray-200 rounded-md dark:text-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50">
                {{ __('Back to My Companies') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="mx-auto max-w-7xl sm:px-6 lg:px-8">
            <div class="p-6 overflow-hidden bg-white shadow-sm dark:bg-gray-800 sm:rounded-lg">
                <form method="POST" action="{{ route('frontend.businessdirectory.my-companies.store') }}" enctype="multipart/form-data">
                    @csrf
                    @include('businessdirectory::frontend.companies._my_company_form', [
                        'companyTypes' => $companyTypes,
                        'company' => $company, // Pass the new Company instance
                    ])
                </form>
            </div>
        </div>
    </div>
</x-app-layout>