@extends('layouts.frontend')

@section('title', 'Companies in ' . $companyType->name . ' - ' . setting('site_name', 'Digital Vocano'))

@section('content')
<div class="container mx-auto px-4 py-8">
    {{-- <div class="mb-6">
        <a href="{{-- route('frontend.businessdirectory.company-types.index') --}}" class="text-indigo-600 dark:text-indigo-400 hover:underline">&larr; Back to Company Types</a>
    </div> --}}
    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-2">Companies in: {{ $companyType->name }}</h1>
    @if($companyType->description)
        <p class="text-gray-600 dark:text-gray-400 mb-6">{{ $companyType->description }}</p>
    @endif

    {{-- Basic Search Form --}}
    <form method="GET" action="{{ route('frontend.businessdirectory.companies.by-type', $companyType->slug) }}" class="mb-8">
        <div class="flex">
            <input type="text" name="search" placeholder="Search companies in {{ $companyType->name }}..." value="{{ request('search') }}"
                   class="w-full md:w-1/2 px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-l-md focus:outline-none focus:ring-2 focus:ring-indigo-500 dark:bg-gray-700 dark:text-gray-200">
            <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-r-md hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500">
                Search
            </button>
        </div>
    </form>

    @if($companies->isEmpty())
        <p class="text-gray-600 dark:text-gray-400">No companies found in this category.</p>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
            @foreach($companies as $company)
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-hidden group">
                    @if($company->hasCustomLogo()) {{-- Use model helper and accessor --}}
                        <img src="{{ $company->logo_url_public }}" alt="{{ $company->name }} Logo" class="w-full h-32 object-contain p-4 bg-gray-100 dark:bg-gray-700">
                    @else
                        <div class="w-full h-32 bg-gray-200 dark:bg-gray-700 flex items-center justify-center text-gray-400">No Logo</div>
                    @endif
                    <div class="p-6">
                        <h2 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-2">{{ $company->name }}</h2>
                        <p class="text-gray-600 dark:text-gray-400 text-sm mb-4">{{ Str::limit(strip_tags($company->description), 120) }}</p>
                        <a href="{{ route('frontend.businessdirectory.companies.show', $company->slug) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline font-semibold">View Profile &rarr;</a>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="mt-8">
            {{ $companies->links() }}
        </div>
    @endif
</div>
@endsection
