{{--
    This partial expects:
    - $companyTypes: Collection of company types (id => name)
    - $company: The company model instance (new Company() for create, existing for edit)
    - $isEdit: (Optional) boolean, true if editing, defaults to false. Used for button text.
--}}
<div class="space-y-6">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company Name <span class="text-red-500">*</span></label>
        <input type="text" name="name" id="name" value="{{ old('name', $company->name ?? '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('name') border-red-500 @enderror">
        @error('name') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="company_type_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Industry / Company Type <span class="text-red-500">*</span></label>
        <select name="company_type_id" id="company_type_id" required
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md @error('company_type_id') border-red-500 @enderror">
            <option value="">Select Industry</option>
            @foreach($companyTypes as $id => $name)
                <option value="{{ $id }}" {{ (old('company_type_id', $company->company_type_id ?? '') == $id) ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </select>
        @error('company_type_id') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company Description <span class="text-red-500">*</span></label>
        <textarea name="description" id="description" rows="6" required
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('description') border-red-500 @enderror">{{ old('description', $company->description ?? '') }}</textarea>
        @error('description') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Contact Email <span class="text-red-500">*</span></label>
            <input type="email" name="email" id="email" value="{{ old('email', $company->email ?? '') }}" required
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('email') border-red-500 @enderror">
            @error('email') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="phone_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Contact Phone</label>
            <input type="tel" name="phone_number" id="phone_number" value="{{ old('phone_number', $company->phone_number ?? '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('phone_number') border-red-500 @enderror">
            @error('phone_number') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>

    <div>
        <label for="website_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Website URL</label>
        <input type="url" name="website_url" id="website_url" value="{{ old('website_url', $company->website_url ?? '') }}" placeholder="https://example.com"
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('website_url') border-red-500 @enderror">
        @error('website_url') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>
    <div>
        <label for="whatsapp_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300">WhatsApp Number</label>
        <input type="text" name="whatsapp_number" id="whatsapp_number" value="{{ old('whatsapp_number', $company->whatsapp_number ?? '') }}"
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('whatsapp_number') border-red-500 @enderror">
        @error('whatsapp_number') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-gray-100">Address Details</h3>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="address_line_1" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Address Line 1</label>
            <input type="text" name="address_line_1" id="address_line_1" value="{{ old('address_line_1', $company->address_line_1 ?? '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('address_line_1') border-red-500 @enderror">
            @error('address_line_1') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="address_line_2" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Address Line 2 (Optional)</label>
            <input type="text" name="address_line_2" id="address_line_2" value="{{ old('address_line_2', $company->address_line_2 ?? '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('address_line_2') border-red-500 @enderror">
            @error('address_line_2') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="city" class="block text-sm font-medium text-gray-700 dark:text-gray-300">City</label>
            <input type="text" name="city" id="city" value="{{ old('city', $company->city ?? '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('city') border-red-500 @enderror">
            @error('city') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="state_province" class="block text-sm font-medium text-gray-700 dark:text-gray-300">State / Province</label>
            <input type="text" name="state_province" id="state_province" value="{{ old('state_province', $company->state_province ?? '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('state_province') border-red-500 @enderror">
            @error('state_province') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="postal_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300">ZIP / Postal Code</label>
            <input type="text" name="postal_code" id="postal_code" value="{{ old('postal_code', $company->postal_code ?? '') }}"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('postal_code') border-red-500 @enderror">
            @error('postal_code') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div class="md:col-span-2">
            <label for="country_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Country Code (2-letter)</label>
            <input type="text" name="country_code" id="country_code" value="{{ old('country_code', $company->country_code ?? '') }}" placeholder="e.g., US, GB" maxlength="2"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('country_code') border-red-500 @enderror">
            @error('country_code') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4 items-end">
        <div>
            <label for="latitude" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Latitude (Optional)</label>
            <input type="text" name="latitude" id="latitude" value="{{ old('latitude', $company->latitude ?? '') }}" placeholder="e.g., 34.0522"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('latitude') border-red-500 @enderror">
            @error('latitude') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="longitude" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Longitude (Optional)</label>
            <input type="text" name="longitude" id="longitude" value="{{ old('longitude', $company->longitude ?? '') }}" placeholder="e.g., -118.2437"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('longitude') border-red-500 @enderror">
            @error('longitude') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div class="md:col-span-2">
            <button type="button" id="fetch-coordinates-btn"
                    class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-gray-600 hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 dark:bg-gray-500 dark:hover:bg-gray-600 dark:focus:ring-offset-gray-800">
                <i class="fas fa-map-marked-alt mr-2"></i> Fetch Coordinates from Address
            </button>
            <p id="coordinates-status" class="mt-1 text-xs text-gray-500 dark:text-gray-400"></p>
        </div>
    </div>

    <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-gray-100">Branding</h3>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Upload your company logo and a banner image.</p>
    </div>

    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-8">
        <div>
            <label for="logo_path" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company Logo</label>
            <div class="mt-2 flex items-center gap-x-3">
        @if(isset($company) && $company->hasCustomLogo()) {{-- Assuming hasCustomLogo() and logo_url_public accessor --}}
            <img src="{{ $company->logo_url_public }}" alt="Current Logo" class="h-16 w-16 object-contain rounded-md border border-gray-300 dark:border-gray-600">
                @else
                    <div class="h-16 w-16 flex items-center justify-center rounded-md border border-dashed border-gray-300 dark:border-gray-600 text-gray-400 dark:text-gray-500">
                        <i class="fas fa-image fa-2x"></i>
                    </div>
                @endif
                <input type="file" name="logo_path" id="logo_path" accept="image/*"
                       class="block w-full text-sm text-gray-500 dark:text-gray-400
                              file:mr-4 file:py-2 file:px-4
                              file:rounded-md file:border-0
                              file:text-sm file:font-semibold
                              file:bg-blue-50 dark:file:bg-blue-800 file:text-blue-700 dark:file:text-blue-200
                              hover:file:bg-blue-100 dark:hover:file:bg-blue-700
                              @error('logo_path') border-red-500 @enderror">
            </div>
            @error('logo_path') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Leave blank to keep current. Max 2MB. (JPG, PNG, GIF, SVG, WEBP)</p>
        </div>

        <div>
            <label for="banner_image_path" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company Banner / Cover Image</label>
            <div>
                <input type="file" name="banner_image_path" id="banner_image_path" accept="image/*"
                       class="mt-2 block w-full text-sm text-gray-500 dark:text-gray-400
                              file:mr-4 file:py-2 file:px-4
                              file:rounded-md file:border-0
                              file:text-sm file:font-semibold
                              file:bg-blue-50 dark:file:bg-blue-800 file:text-blue-700 dark:file:text-blue-200
                              hover:file:bg-blue-100 dark:hover:file:bg-blue-700
                              @error('banner_image_path') border-red-500 @enderror">
            </div>
    @error('banner_image_path') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    @if(isset($company) && $company->hasCustomBanner()) {{-- Assuming hasCustomBanner() and banner_url_public accessor --}}
        <img src="{{ $company->banner_url_public }}" alt="Current Banner" class="mt-2 h-24 w-full object-cover rounded-md border border-gray-300 dark:border-gray-600">
            @else
                 <div class="mt-2 h-24 w-full flex items-center justify-center rounded-md border border-dashed border-gray-300 dark:border-gray-600 text-gray-400 dark:text-gray-500">
                    <i class="fas fa-image fa-2x"></i>
                    <span class="ml-2">Banner Preview</span>
                </div>
            @endif
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Leave blank to keep current. Max 5MB. (JPG, PNG, WEBP). Recommended aspect ratio 3:1 or wider.</p>
        </div>
    </div>

    <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-gray-100">Additional Information</h3>
    </div>
    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label for="established_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Established Date</label>
                <input type="date" name="established_date" id="established_date" value="{{ old('established_date', isset($company->established_date) ? ($company->established_date instanceof \Carbon\Carbon ? $company->established_date->format('Y-m-d') : $company->established_date) : '') }}"
                       class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('established_date') border-red-500 @enderror">
                @error('established_date') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>
            <div>
                <label for="employee_count" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Number of Employees</label>
                <input type="text" name="employee_count" id="employee_count" value="{{ old('employee_count', $company->employee_count ?? '') }}" placeholder="e.g., 10-50"
                       class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('employee_count') border-red-500 @enderror">
                @error('employee_count') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>
    </div>
    <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-gray-100">Social Media Links</h3>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Provide links to your company's social media profiles.</p>
    </div>
    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="facebook_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Facebook URL</label>
            <input type="url" name="facebook_url" id="facebook_url" value="{{ old('facebook_url', $company->social_links['facebook'] ?? '') }}" placeholder="https://facebook.com/yourcompany"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('facebook_url') border-red-500 @enderror">
            @error('facebook_url') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="twitter_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Twitter (X) URL</label>
            <input type="url" name="twitter_url" id="twitter_url" value="{{ old('twitter_url', $company->social_links['twitter'] ?? '') }}" placeholder="https://twitter.com/yourcompany"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('twitter_url') border-red-500 @enderror">
            @error('twitter_url') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="linkedin_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">LinkedIn URL</label>
            <input type="url" name="linkedin_url" id="linkedin_url" value="{{ old('linkedin_url', $company->social_links['linkedin'] ?? '') }}" placeholder="https://linkedin.com/company/yourcompany"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('linkedin_url') border-red-500 @enderror">
            @error('linkedin_url') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="instagram_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Instagram URL</label>
            <input type="url" name="instagram_url" id="instagram_url" value="{{ old('instagram_url', $company->social_links['instagram'] ?? '') }}" placeholder="https://instagram.com/yourcompany"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('instagram_url') border-red-500 @enderror">
            @error('instagram_url') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>

    <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-gray-100">SEO Meta Information</h3>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Optimize how your company appears in search engine results.</p>
    </div>
    <div class="mt-6 space-y-6">
        <div>
            <label for="meta_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Title (Optional)</label>
            <input type="text" name="meta_title" id="meta_title" value="{{ old('meta_title', $company->meta_title ?? '') }}" maxlength="255"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('meta_title') border-red-500 @enderror"
                   placeholder="e.g., Best Tech Solutions in New York | YourCompany">
            @error('meta_title') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Recommended length: 50-60 characters.</p>
        </div>
        <div>
            <label for="meta_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Description (Optional)</label>
            <textarea name="meta_description" id="meta_description" rows="3" maxlength="1000"
                      class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('meta_description') border-red-500 @enderror"
                      placeholder="e.g., YourCompany offers innovative tech solutions and services in New York. Contact us for custom software development and IT consulting.">{{ old('meta_description', $company->meta_description ?? '') }}</textarea>
            @error('meta_description') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Recommended length: 150-160 characters.</p>
        </div>
        <div>
            <label for="meta_keywords" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Keywords (Optional, Comma-separated)</label>
            <input type="text" name="meta_keywords" id="meta_keywords" value="{{ old('meta_keywords', $company->meta_keywords ?? '') }}" maxlength="255"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('meta_keywords') border-red-500 @enderror"
                   placeholder="e.g., tech solutions, IT consulting, software development, New York">
            @error('meta_keywords') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">While less impactful now, can still be useful. List relevant keywords.</p>
        </div>
    </div>

    <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-gray-100">E-commerce Settings</h3>
    </div>
    <div class="mt-4">
        <div class="relative flex items-start p-4 border border-gray-200 dark:border-gray-700 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
            <div class="flex h-6 items-center">
                <input id="is_ecommerce" name="is_ecommerce" type="checkbox" value="1" {{ old('is_ecommerce', $company->is_ecommerce ?? false) ? 'checked' : '' }}
                       class="h-5 w-5 rounded border-gray-300 dark:border-gray-600 text-blue-600 focus:ring-blue-600 dark:bg-gray-900 dark:ring-offset-gray-800 dark:checked:bg-blue-500">
            </div>
            <div class="ml-3 text-sm leading-6">
                <label for="is_ecommerce" class="font-medium text-gray-900 dark:text-gray-100 cursor-pointer">Enable E-commerce Features</label>
                <p class="text-gray-500 dark:text-gray-400">If checked, you will be able to list products for sale under this company profile and manage orders.</p>
            </div>
        </div>
        @error('is_ecommerce') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="pt-8">
        <div class="flex justify-end space-x-3">
            <a href="{{ route('frontend.businessdirectory.my-companies.index') }}"
               class="bg-white dark:bg-gray-700 py-2 px-4 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                Cancel
            </a>
            <button type="submit"
                    class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
                {{ ($isEdit ?? false) ? 'Update Company Profile' : 'Submit for Approval' }}
            </button>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const fetchButton = document.getElementById('fetch-coordinates-btn');
        const latitudeInput = document.getElementById('latitude');
        const longitudeInput = document.getElementById('longitude');
        const addressLine1Input = document.getElementById('address_line_1');
        const cityInput = document.getElementById('city');
        const stateProvinceInput = document.getElementById('state_province');
        const postalCodeInput = document.getElementById('postal_code');
        const countryCodeInput = document.getElementById('country_code'); // Assuming 2-letter country code
        const statusElement = document.getElementById('coordinates-status');

        if (fetchButton) {
            fetchButton.addEventListener('click', function () {
                let addressParts = [];
                if (addressLine1Input && addressLine1Input.value) addressParts.push(addressLine1Input.value);
                if (cityInput && cityInput.value) addressParts.push(cityInput.value);
                if (stateProvinceInput && stateProvinceInput.value) addressParts.push(stateProvinceInput.value);
                if (postalCodeInput && postalCodeInput.value) addressParts.push(postalCodeInput.value);
                // Nominatim prefers full country name, but we can try with code if that's what we have
                if (countryCodeInput && countryCodeInput.value) addressParts.push(countryCodeInput.value);

                const addressString = addressParts.join(', ');

                if (!addressString.trim()) {
                    statusElement.textContent = 'Please enter some address details first.';
                    statusElement.className = 'mt-1 text-xs text-red-500 dark:text-red-400';
                    return;
                }

                statusElement.textContent = 'Fetching coordinates...';
                statusElement.className = 'mt-1 text-xs text-blue-500 dark:text-blue-400';

                // Use a more specific query if possible, e.g., by separating street, city, etc.
                // For simplicity, we'll use a combined string.
                // Add a User-Agent as per Nominatim's usage policy
                fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(addressString)}&limit=1`, {
                    headers: {
                        'User-Agent': '{{ config('app.name', 'Laravel App') }} - Company Geocoding'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data && data.length > 0) {
                        const lat = parseFloat(data[0].lat).toFixed(7);
                        const lon = parseFloat(data[0].lon).toFixed(7);
                        if (latitudeInput) latitudeInput.value = lat;
                        if (longitudeInput) longitudeInput.value = lon;
                        statusElement.textContent = 'Coordinates fetched successfully!';
                        statusElement.className = 'mt-1 text-xs text-green-500 dark:text-green-400';
                    } else {
                        statusElement.textContent = 'Could not find coordinates for the address.';
                        statusElement.className = 'mt-1 text-xs text-red-500 dark:text-red-400';
                    }
                })
                .catch(error => {
                    console.error('Error fetching coordinates:', error);
                    statusElement.textContent = 'Error fetching coordinates. Check console.';
                    statusElement.className = 'mt-1 text-xs text-red-500 dark:text-red-400';
                });
            });
        }
    });
</script>
@endpush
