@extends('layouts.frontend') {{-- Your TALL stack frontend layout --}}

@section('title', 'Checkout')

@section('content')
<div class="bg-gray-100 py-12">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-10 text-center">
            <h1 class="text-3xl font-bold text-blue-700">Checkout</h1>
        </header>

        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-6" role="alert">
                <strong class="font-bold">Error!</strong>
                <span class="block sm:inline">{{ session('error') }}</span>
            </div>
        @endif

        <form action="{{ route('frontend.businessdirectory.checkout.place-order') }}" method="POST" id="checkout-form">
            @csrf
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                {{-- Shipping & Billing Information --}}
                <div class="lg:col-span-2 bg-white shadow-lg rounded-lg p-6 space-y-6">
                    <div>
                        <h2 class="text-xl font-semibold text-gray-800 mb-4 border-b pb-2">Shipping Address</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="shipping_name" class="block text-sm font-medium text-gray-700">Full Name <span class="text-red-500">*</span></label>
                                <input type="text" name="shipping_name" id="shipping_name" value="{{ old('shipping_name', Auth::user()->name ?? '') }}" required
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('shipping_name') border-red-500 @enderror">
                                @error('shipping_name') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            </div>
                             <div>
                                <label for="shipping_email" class="block text-sm font-medium text-gray-700">Email <span class="text-red-500">*</span></label>
                                <input type="email" name="shipping_email" id="shipping_email" value="{{ old('shipping_email', Auth::user()->email ?? '') }}" required
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('shipping_email') border-red-500 @enderror">
                                @error('shipping_email') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            </div>
                            <div class="md:col-span-2">
                                <label for="shipping_address_line_1" class="block text-sm font-medium text-gray-700">Address Line 1 <span class="text-red-500">*</span></label>
                                <input type="text" name="shipping_address_line_1" id="shipping_address_line_1" value="{{ old('shipping_address_line_1') }}" required
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('shipping_address_line_1') border-red-500 @enderror">
                                @error('shipping_address_line_1') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="shipping_city" class="block text-sm font-medium text-gray-700">City <span class="text-red-500">*</span></label>
                                <input type="text" name="shipping_city" id="shipping_city" value="{{ old('shipping_city') }}" required
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('shipping_city') border-red-500 @enderror">
                                @error('shipping_city') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="shipping_state" class="block text-sm font-medium text-gray-700">State / Province <span class="text-red-500">*</span></label>
                                <input type="text" name="shipping_state" id="shipping_state" value="{{ old('shipping_state') }}" required
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('shipping_state') border-red-500 @enderror">
                                @error('shipping_state') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="shipping_zip_code" class="block text-sm font-medium text-gray-700">ZIP / Postal Code <span class="text-red-500">*</span></label>
                                <input type="text" name="shipping_zip_code" id="shipping_zip_code" value="{{ old('shipping_zip_code') }}" required
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('shipping_zip_code') border-red-500 @enderror">
                                @error('shipping_zip_code') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="shipping_country" class="block text-sm font-medium text-gray-700">Country <span class="text-red-500">*</span></label>
                                <input type="text" name="shipping_country" id="shipping_country" value="{{ old('shipping_country') }}" required
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('shipping_country') border-red-500 @enderror">
                                @error('shipping_country') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            </div>
                        </div>
                        {{-- Add checkbox for "Billing address same as shipping" and conditional billing address fields if needed --}}
                    </div>

                    <div>
                        <h2 class="text-xl font-semibold text-gray-800 mb-4 border-b pb-2">Payment Method</h2>
                        <div class="space-y-3">
                            {{-- This section needs to be dynamically populated based on available payment gateways --}}
                            {{-- Example: Stripe Elements, PayPal button, M-Pesa, etc. --}}
                            <div class="p-4 border rounded-md bg-gray-50">
                                <label class="flex items-center">
                                    <input type="radio" name="payment_method" value="simulated_card" class="form-radio h-4 w-4 text-blue-600 border-gray-300" checked>
                                    <span class="ml-2 text-sm text-gray-700">Simulated Card Payment (For Demo)</span>
                                </label>
                                {{-- Placeholder for actual payment gateway integration (e.g., Stripe Elements div) --}}
                                <div id="card-element" class="mt-2 p-3 border border-gray-300 rounded-md bg-white">
                                    <!-- A Stripe Element will be inserted here. -->
                                    <p class="text-xs text-gray-500">Actual payment gateway integration needed here.</p>
                                </div>
                            </div>

                            {{-- Add other payment methods as needed --}}
                            {{-- <div class="p-4 border rounded-md">
                                <label class="flex items-center">
                                    <input type="radio" name="payment_method" value="paypal" class="form-radio h-4 w-4 text-blue-600 border-gray-300">
                                    <span class="ml-2 text-sm text-gray-700">PayPal</span>
                                </label>
                            </div> --}}
                             <div class="p-4 border rounded-md bg-gray-50">
                                <label class="flex items-center">
                                    <input type="radio" name="payment_method" value="manual_transfer" class="form-radio h-4 w-4 text-blue-600 border-gray-300">
                                    <span class="ml-2 text-sm text-gray-700">Manual Bank Transfer</span>
                                </label>
                                <div class="mt-2 text-xs text-gray-500 p-2 bg-blue-50 rounded">
                                    <p>Instructions for manual bank transfer will be provided after placing the order.</p>
                                </div>
                            </div>
                        </div>
                        @error('payment_method') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>
                     <div>
                        <label for="order_notes" class="block text-sm font-medium text-gray-700">Order Notes (Optional)</label>
                        <textarea name="order_notes" id="order_notes" rows="3"
                                  class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">{{ old('order_notes') }}</textarea>
                    </div>
                </div>

                {{-- Order Summary --}}
                <div class="lg:col-span-1">
                    <div class="bg-white shadow-lg rounded-lg p-6 sticky top-28"> {{-- sticky top for summary --}}
                        <h2 class="text-xl font-semibold text-gray-800 mb-4 border-b pb-2">Order Summary</h2>
                        @if($cart && $cart->items->isNotEmpty())
                            <div class="space-y-3 mb-4">
                                @foreach($cart->items as $item)
                                <div class="flex justify-between items-center text-sm">
                                    <div>
                                        <p class="text-gray-800">{{ $item->product->name ?? 'N/A' }} <span class="text-xs text-gray-500">x {{ $item->quantity }}</span></p>
                                        <p class="text-xs text-gray-500">{{ $item->product->company->name ?? 'N/A' }}</p>
                                    </div>
                                    <p class="text-gray-600">{{ $item->product->currency ?? '$' }}{{ number_format($item->subtotal, 2) }}</p>
                                </div>
                                @endforeach
                            </div>
                            <hr class="my-4">
                            <div class="flex justify-between text-sm font-medium text-gray-700 mb-1">
                                <p>Subtotal</p>
                                <p>{{ $cart->items->first()->product->currency ?? '$' }}{{ number_format($cart->total_amount, 2) }}</p>
                            </div>
                            <div class="flex justify-between text-xs text-gray-500 mb-1">
                                <p>Shipping</p>
                                <p>Calculated later / Free</p> {{-- Placeholder --}}
                            </div>
                            <div class="flex justify-between text-xs text-gray-500 mb-4">
                                <p>Taxes</p>
                                <p>Calculated later</p> {{-- Placeholder --}}
                            </div>
                            <hr class="my-4">
                            <div class="flex justify-between text-lg font-bold text-gray-900">
                                <p>Total</p>
                                <p>{{ $cart->items->first()->product->currency ?? '$' }}{{ number_format($cart->total_amount, 2) }}</p>
                            </div>

                            <div class="mt-6">
                                <button type="submit"
                                        class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-4 rounded-md shadow-sm text-base">
                                    Place Order
                                </button>
                            </div>
                            <p class="mt-4 text-xs text-gray-500 text-center">
                                By placing your order, you agree to our <a href="#" class="text-blue-600 hover:underline">terms and conditions</a> and <a href="#" class="text-blue-600 hover:underline">privacy policy</a>.
                            </p>
                        @else
                            <p class="text-gray-600">Your cart is empty. Add items to proceed.</p>
                            <a href="{{ route('frontend.businessdirectory.cart.index') }}" class="mt-4 inline-block text-blue-600 hover:underline">Return to Cart</a>
                        @endif
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
{{--
    If using Stripe Elements:
    <script src="https://js.stripe.com/v3/"></script>
    <script>
        const stripe = Stripe('YOUR_STRIPE_PUBLISHABLE_KEY');
        const elements = stripe.elements();
        const cardElement = elements.create('card', {
            // style: { base: { ... } }
        });
        cardElement.mount('#card-element');

        const form = document.getElementById('checkout-form');
        form.addEventListener('submit', async (event) => {
            if (document.querySelector('input[name="payment_method"]:checked').value === 'simulated_card') { // Or your actual card method value
                event.preventDefault();
                const {token, error} = await stripe.createToken(cardElement);
                if (error) {
                    // Inform the user if there was an error.
                    const errorElement = document.getElementById('card-errors'); // You'll need this element
                    errorElement.textContent = error.message;
                } else {
                    // Send the token to your server.
                    stripeTokenHandler(token);
                }
            }
        });

        function stripeTokenHandler(token) {
            const form = document.getElementById('checkout-form');
            const hiddenInput = document.createElement('input');
            hiddenInput.setAttribute('type', 'hidden');
            hiddenInput.setAttribute('name', 'stripeToken'); // Your backend will look for this
            hiddenInput.setAttribute('value', token.id);
            form.appendChild(hiddenInput);
            form.submit();
        }
    </script>
--}}
@endpush