{{-- d:\projects\digitalvocano\Modules\BusinessDirectory\resources\views\frontend\categories\show.blade.php --}}
@extends('layouts.frontend')

@section('title', $category->name . ' - ' . setting('site_name', 'Digital Vocano'))
@section('meta_description', $category->description ?: 'Browse listings in the ' . $category->name . ' category.')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-2">{{ $category->name }}</h1>
    @if($category->description)
        <p class="text-gray-600 dark:text-gray-400 mb-6">{{ $category->description }}</p>
    @endif

    {{-- You can add a search/filter form specific to this category here --}}

    <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-100 mb-4">Companies in this Category</h2>

    @if($companies->isEmpty())
        <p class="text-gray-600 dark:text-gray-400">No companies found in this category yet.</p>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
            @foreach($companies as $company)
                {{-- Include your company card partial here --}}
                {{-- Make sure your company card partial can handle the $company object --}}
                @include('businessdirectory::frontend.partials._company_card', ['company' => $company])
                {{-- If you don't have a generic company card partial, you can put the card HTML directly here --}}
                {{-- Example basic card: --}}
                {{-- <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-hidden">
                    @if($company->hasCustomLogo())
                        <img src="{{ $company->logo_url_public }}" alt="{{ $company->name }} Logo" class="w-full h-32 object-contain p-4 bg-gray-100 dark:bg-gray-700">
                    @endif
                    <div class="p-4">
                        <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200">{{ $company->name }}</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mt-2 line-clamp-2">{{ Str::limit(strip_tags($company->description), 100) }}</p>
                        <a href="{{ active_public_route_url('companies.show', ['company' => $company->slug]) }}" class="mt-3 inline-block text-indigo-600 dark:text-indigo-400 hover:underline">View Profile &rarr;</a>
                    </div>
                </div> --}}
            @endforeach
        </div>
        <div class="mt-8">
            {{ $companies->links() }}
        </div>
    @endif

    {{-- You might also list products, jobs, tenders related to this category here --}}
    {{-- <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-100 mt-8 mb-4">Products in this Category</h2> --}}
    {{-- ... loop through products ... --}}
</div>
@endsection