<x-app-layout> {{-- Or your general frontend layout if cart is for guests too --}}
    @section('title', __('Shopping Cart'))

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('Shopping Cart') }}
            </h2>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Session messages are handled by app.blade.php --}}

            @if ($cart && $cart->items->isNotEmpty())
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                    <div class="lg:col-span-2 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                            <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100">Your Cart Items ({{ $cart->items->sum('quantity') }})</h3>
                        </div>
                        <div class="divide-y divide-gray-200 dark:divide-gray-700">
                            @foreach ($cart->items as $item)
                                <div class="p-4 sm:p-6 flex flex-col sm:flex-row items-start sm:items-center space-y-4 sm:space-y-0 sm:space-x-4">
                                    @if ($item->product->featured_image_url)
                                        <img src="{{ $item->product->featured_image_url }}" alt="{{ $item->product->name }}" class="w-24 h-24 object-cover rounded-md self-center sm:self-start">
                                    @else
                                        <div class="w-24 h-24 bg-gray-200 dark:bg-gray-700 rounded-md flex items-center justify-center text-gray-400 dark:text-gray-500 self-center sm:self-start">
                                            <i class="fas fa-image fa-2x"></i>
                                        </div>
                                    @endif
                                    <div class="flex-1 min-w-0">
                                        <a href="{{ route('frontend.businessdirectory.products.show', $item->product->slug) }}" class="text-md font-medium text-gray-900 dark:text-gray-100 hover:text-blue-600 dark:hover:text-blue-400">{{ $item->product->name }}</a>
                                        <p class="text-sm text-gray-500 dark:text-gray-400">Sold by: {{ $item->product->company->name ?? 'N/A' }}</p>
                                        <p class="text-sm text-gray-500 dark:text-gray-400">Unit Price: ${{ number_format($item->price_at_addition, 2) }}</p>
                                    </div>
                                    <div class="flex items-center space-x-3 self-center sm:self-auto">
                                        <form action="{{ route('frontend.businessdirectory.cart.update', $item->id) }}" method="POST" class="flex items-center">
                                            @csrf
                                            @method('PATCH')
                                            <input type="number" name="quantity" value="{{ $item->quantity }}" min="1" max="{{ $item->product->stock_quantity }}"
                                                   class="w-16 px-2 py-1 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                                   onchange="this.form.submit()">
                                        </form>
                                        <form action="{{ route('frontend.businessdirectory.cart.remove', $item->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-500 hover:text-red-700 dark:text-red-400 dark:hover:text-red-300" title="Remove item">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                    <div class="text-md font-semibold text-gray-900 dark:text-gray-100 self-center sm:self-auto sm:ml-auto">
                                        ${{ number_format($item->quantity * $item->price_at_addition, 2) }}
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="p-6 border-t border-gray-200 dark:border-gray-700">
                            <a href="{{ route('frontend.businessdirectory.cart.clear') }}"
                               onclick="return confirm('Are you sure you want to clear your cart?')"
                               class="text-sm text-red-600 dark:text-red-400 hover:text-red-800 dark:hover:text-red-300">
                                Clear Cart
                            </a>
                        </div>
                    </div>

                    <div class="lg:col-span-1">
                        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6 sticky top-8">
                            <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Order Summary</h3>
                            <div class="space-y-2">
                                <div class="flex justify-between text-gray-700 dark:text-gray-300">
                                    <span>Subtotal</span>
                                    <span>${{ number_format($cart->items->sum(fn($item) => $item->quantity * $item->price_at_addition), 2) }}</span>
                                </div>
                                {{-- Add shipping, taxes if applicable --}}
                                <div class="flex justify-between text-lg font-semibold text-gray-900 dark:text-gray-100 pt-2 border-t border-gray-200 dark:border-gray-700">
                                    <span>Total</span>
                                    <span>${{ number_format($cart->items->sum(fn($item) => $item->quantity * $item->price_at_addition), 2) }}</span>
                                </div>
                            </div>
                            <div class="mt-6">
                                <a href="{{ route('frontend.checkout.index') }}" {{-- Assuming you have a checkout route --}}
                                   class="w-full flex items-center justify-center px-6 py-3 border border-transparent rounded-md shadow-sm text-base font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                    Proceed to Checkout
                                </a>
                            </div>
                            <div class="mt-4 text-center">
                                <a href="{{ route('frontend.businessdirectory.products.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:underline">
                                    Continue Shopping
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-16 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                    <i class="fas fa-shopping-cart fa-4x text-gray-300 dark:text-gray-600 mb-4"></i>
                    <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-2">Your Cart is Empty</h2>
                    <p class="text-gray-500 dark:text-gray-400 mb-6">Looks like you haven't added anything to your cart yet.</p>
                    <a href="{{ route('frontend.businessdirectory.products.index') }}" {{-- Or your main shop page --}}
                       class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md">
                        Browse Products
                    </a>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
