<x-app-layout>
    @section('title', __('My Bid Details for: ') . $bid->tender->title)

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <div>
                <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                    {{ __('My Bid Details') }}
                </h2>
                <p class="text-sm text-gray-500 dark:text-gray-400">
                    For Tender: <a href="{{ route('frontend.businessdirectory.tenders.show', $bid->tender->slug) }}" class="text-blue-600 dark:text-blue-400 hover:underline">{{ $bid->tender->title }}</a>
                </p>
            </div>
            <a href="{{ route('frontend.businessdirectory.my-submitted-bids.index') }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-gray-700 dark:text-gray-300 capitalize transition-colors duration-300 transform bg-gray-200 dark:bg-gray-700 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> {{ __('Back to My Bids') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
                <div class="p-6 md:p-8">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                        <div>
                            <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Bid Status</h3>
                            <p class="mt-1 text-lg font-medium text-gray-900 dark:text-gray-100">
                                <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full {{ $bid->status_class ?? 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-100' }}">
                                    {{ Str::title(str_replace('_', ' ', $bid->status)) }}
                                </span>
                            </p>
                        </div>
                        <div>
                            <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Bid Amount</h3>
                            <p class="mt-1 text-lg text-gray-900 dark:text-gray-100">
                                {{ $bid->bid_amount ? ($bid->tender->budget_currency ?? '$') . number_format($bid->bid_amount, 2) : 'Not Specified' }}
                            </p>
                        </div>
                        <div>
                            <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Submitted On</h3>
                            <p class="mt-1 text-lg text-gray-900 dark:text-gray-100">{{ $bid->created_at->format('M d, Y H:i A') }}</p>
                        </div>
                    </div>

                    @if($bid->bidderCompany)
                    <div class="mb-6">
                        <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Submitted As</h3>
                        <p class="mt-1 text-md text-gray-700 dark:text-gray-300">{{ $bid->bidderCompany->name }} (Company)</p>
                    </div>
                    @else
                    <div class="mb-6">
                        <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Submitted As</h3>
                        <p class="mt-1 text-md text-gray-700 dark:text-gray-300">{{ $bid->bidderUser->name ?? Auth::user()->name }} (Individual)</p>
                    </div>
                    @endif

                    <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                        <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-100 mb-3">Proposal Details</h3>
                        <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                            {!! nl2br(e($bid->proposal_details)) !!}
                        </div>
                    </div>

                    {{-- Attachments Section (if you implement this) --}}
                    {{--
                    @if($bid->attachments && count($bid->attachments) > 0)
                    <div class="border-t border-gray-200 dark:border-gray-700 pt-6 mt-6">
                        <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-100 mb-3">Attachments</h3>
                        <ul class="list-disc list-inside space-y-1">
                            @foreach($bid->attachments as $attachment)
                                <li>
                                    <a href="{{ Storage::url($attachment->path) }}" target="_blank" class="text-blue-600 dark:text-blue-400 hover:underline">
                                        {{ $attachment->filename ?? 'Download Attachment' }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    --}}

                    @can('withdraw', $bid)
                        <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700 text-right">
                            <form action="{{ route('frontend.businessdirectory.my-submitted-bids.withdraw', $bid->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to withdraw this bid? This action cannot be undone.');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                    Withdraw Bid
                                </button>
                            </form>
                        </div>
                    @endcan
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
