@extends('layouts.admin') {{-- Or your main admin layout, e.g., businessdirectory::layouts.admin --}}

@section('title', 'Business Directory Settings')

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Business Directory Settings</h1>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="max-w-4xl mx-auto">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Manage Frontend and General Settings</h3>
            </div>
                <form action="{{ route('admin.businessdirectory.settings.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="p-6 space-y-8">
                        @include('businessdirectory::admin.partials._alerts')

                        {{-- General Settings --}}
                        <section>
                            <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">General Site Information</h3>
                            <div class="space-y-4">
                                <div>
                                    <label for="site_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Site Name <span class="text-red-500">*</span></label>
                                    <input type="text" name="site_name" id="site_name" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('site_name') border-red-500 @enderror" value="{{ old('site_name', $settings->site_name) }}" required>
                                    @error('site_name') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="site_tagline" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Site Tagline</label>
                                    <input type="text" name="site_tagline" id="site_tagline" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('site_tagline') border-red-500 @enderror" value="{{ old('site_tagline', $settings->site_tagline) }}">
                                    @error('site_tagline') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="contact_email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Contact Email</label>
                                    <input type="email" name="contact_email" id="contact_email" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('contact_email') border-red-500 @enderror" value="{{ old('contact_email', $settings->contact_email) }}">
                                    @error('contact_email') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                 <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                    <div>
                                        <label for="currency_symbol" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Currency Symbol</label>
                                        <input type="text" name="currency_symbol" id="currency_symbol" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('currency_symbol') border-red-500 @enderror" value="{{ old('currency_symbol', $settings->currency_symbol) }}">
                                        @error('currency_symbol') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                    </div>
                                    <div>
                                        <label for="currency_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Currency Code (e.g., USD)</label>
                                        <input type="text" name="currency_code" id="currency_code" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('currency_code') border-red-500 @enderror" value="{{ old('currency_code', $settings->currency_code) }}">
                                        @error('currency_code') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                    </div>
                                </div>
                            </div>
                        </section>

                        {{-- Social Links --}}
                        <section>
                            <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Social Media Links</h3>
                            <div class="space-y-4">
                                <div>
                                    <label for="social_facebook_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Facebook URL</label>
                                    <input type="url" name="social_facebook_url" id="social_facebook_url" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('social_facebook_url') border-red-500 @enderror" value="{{ old('social_facebook_url', $settings->social_facebook_url) }}">
                                    @error('social_facebook_url') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="social_twitter_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Twitter URL</label>
                                    <input type="url" name="social_twitter_url" id="social_twitter_url" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('social_twitter_url') border-red-500 @enderror" value="{{ old('social_twitter_url', $settings->social_twitter_url) }}">
                                    @error('social_twitter_url') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="social_linkedin_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">LinkedIn URL</label>
                                    <input type="url" name="social_linkedin_url" id="social_linkedin_url" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('social_linkedin_url') border-red-500 @enderror" value="{{ old('social_linkedin_url', $settings->social_linkedin_url) }}">
                                    @error('social_linkedin_url') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="social_instagram_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Instagram URL</label>
                                    <input type="url" name="social_instagram_url" id="social_instagram_url" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('social_instagram_url') border-red-500 @enderror" value="{{ old('social_instagram_url', $settings->social_instagram_url) }}">
                                    @error('social_instagram_url') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                            </div>
                        </section>

                        {{-- Homepage Hero Settings --}}
                        <section>
                            <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Homepage Hero Section</h3>
                            <div class="space-y-4">
                                <div>
                                    <label for="homepage_hero_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Hero Title</label>
                                    <input type="text" name="homepage_hero_title" id="homepage_hero_title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('homepage_hero_title') border-red-500 @enderror" value="{{ old('homepage_hero_title', $settings->homepage_hero_title) }}">
                                    @error('homepage_hero_title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="homepage_hero_subtitle" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Hero Subtitle</label>
                                    <textarea name="homepage_hero_subtitle" id="homepage_hero_subtitle" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('homepage_hero_subtitle') border-red-500 @enderror" rows="3">{{ old('homepage_hero_subtitle', $settings->homepage_hero_subtitle) }}</textarea>
                                    @error('homepage_hero_subtitle') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                 <div>
                                    <label for="homepage_hero_search_placeholder" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Hero Search Placeholder</label>
                                    <input type="text" name="homepage_hero_search_placeholder" id="homepage_hero_search_placeholder" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('homepage_hero_search_placeholder') border-red-500 @enderror" value="{{ old('homepage_hero_search_placeholder', $settings->homepage_hero_search_placeholder) }}">
                                    @error('homepage_hero_search_placeholder') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                            </div>
                        </section>

                        {{-- Hero Slider Images --}}
                        @for ($i = 1; $i <= 2; $i++) {{-- Loop for 2 slides, adjust as needed --}}
                        <section>
                            <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Hero Slide {{ $i }}</h3>
                            <div class="space-y-4 p-4 border border-gray-200 dark:border-gray-700 rounded-md">
                                <div>
                                    <label for="hero_slide_{{ $i }}_image" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Slide {{ $i }} Image (Recommended: 1920x1080 or similar aspect ratio)</label>
                                    <input type="file" name="hero_slide_{{ $i }}_image" id="hero_slide_{{ $i }}_image" class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 dark:file:bg-gray-600 file:text-indigo-700 dark:file:text-indigo-300 hover:file:bg-indigo-100 dark:hover:file:bg-gray-500 @error('hero_slide_'.$i.'_image') border-red-500 @enderror">
                                    @error('hero_slide_'.$i.'_image') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                @php $imagePathSettingKey = 'hero_slide_'.$i.'_image'; @endphp
                                @if($settings->$imagePathSettingKey && Storage::disk('public')->exists($settings->$imagePathSettingKey))
                                    <div class="mt-2">
                                        <img src="{{ Storage::url($settings->$imagePathSettingKey) }}" alt="Slide {{ $i }} Image" class="h-40 w-auto rounded-md object-contain">
                                        <div class="mt-2 flex items-center">
                                            <input type="checkbox" name="remove_hero_slide_{{ $i }}_image" id="remove_hero_slide_{{ $i }}_image" class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500" value="1">
                                            <label for="remove_hero_slide_{{ $i }}_image" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Remove this image on save</label>
                                        </div>
                                    </div>
                                @endif
                                <div>
                                    <label for="hero_slide_{{ $i }}_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Slide {{ $i }} Title</label>
                                    <input type="text" name="hero_slide_{{ $i }}_title" id="hero_slide_{{ $i }}_title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('hero_slide_'.$i.'_title') border-red-500 @enderror" value="{{ old('hero_slide_'.$i.'_title', $settings->{'hero_slide_'.$i.'_title'}) }}">
                                    @error('hero_slide_'.$i.'_title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="hero_slide_{{ $i }}_subtitle" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Slide {{ $i }} Subtitle</label>
                                    <textarea name="hero_slide_{{ $i }}_subtitle" id="hero_slide_{{ $i }}_subtitle" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('hero_slide_'.$i.'_subtitle') border-red-500 @enderror" rows="2">{{ old('hero_slide_'.$i.'_subtitle', $settings->{'hero_slide_'.$i.'_subtitle'}) }}</textarea>
                                    @error('hero_slide_'.$i.'_subtitle') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="hero_slide_{{ $i }}_button_text" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Slide {{ $i }} Button Text</label>
                                    <input type="text" name="hero_slide_{{ $i }}_button_text" id="hero_slide_{{ $i }}_button_text" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('hero_slide_'.$i.'_button_text') border-red-500 @enderror" value="{{ old('hero_slide_'.$i.'_button_text', $settings->{'hero_slide_'.$i.'_button_text'}) }}">
                                    @error('hero_slide_'.$i.'_button_text') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="hero_slide_{{ $i }}_button_link" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Slide {{ $i }} Button Link (URL or relative path like /companies)</label>
                                    <input type="text" name="hero_slide_{{ $i }}_button_link" id="hero_slide_{{ $i }}_button_link" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('hero_slide_'.$i.'_button_link') border-red-500 @enderror" value="{{ old('hero_slide_'.$i.'_button_link', $settings->{'hero_slide_'.$i.'_button_link'}) }}">
                                    @error('hero_slide_'.$i.'_button_link') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                            </div>
                        </section>
                        @endfor

                        {{-- Listing Settings --}}
                        <section>
                            <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Listing & Display Settings</h3>
                            <div class="space-y-4">
                                <div>
                                    <label for="pagination_count" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Default Pagination Count (for listings)</label>
                                    <input type="number" name="pagination_count" id="pagination_count" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('pagination_count') border-red-500 @enderror" value="{{ old('pagination_count', $settings->pagination_count) }}" min="1" required>
                                    @error('pagination_count') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div class="flex items-center">
                                    <input type="checkbox" name="auto_approve_companies" id="auto_approve_companies" class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500" value="1" {{ old('auto_approve_companies', $settings->auto_approve_companies) ? 'checked' : '' }}>
                                    <label for="auto_approve_companies" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Auto-Approve New Company Listings</label>
                                </div>
                                <div>
                                    <label for="homepage_featured_companies_count" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Homepage Featured Companies Count</label>
                                    <input type="number" name="homepage_featured_companies_count" id="homepage_featured_companies_count" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('homepage_featured_companies_count') border-red-500 @enderror" value="{{ old('homepage_featured_companies_count', $settings->homepage_featured_companies_count) }}" min="0">
                                    @error('homepage_featured_companies_count') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                 <div>
                                    <label for="homepage_featured_products_count" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Homepage Featured Products Count</label>
                                    <input type="number" name="homepage_featured_products_count" id="homepage_featured_products_count" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('homepage_featured_products_count') border-red-500 @enderror" value="{{ old('homepage_featured_products_count', $settings->homepage_featured_products_count) }}" min="0">
                                    @error('homepage_featured_products_count') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                 <div>
                                    <label for="homepage_latest_tenders_count" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Homepage Latest Tenders Count</label>
                                    <input type="number" name="homepage_latest_tenders_count" id="homepage_latest_tenders_count" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('homepage_latest_tenders_count') border-red-500 @enderror" value="{{ old('homepage_latest_tenders_count', $settings->homepage_latest_tenders_count) }}" min="0">
                                    @error('homepage_latest_tenders_count') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                                 <div>
                                    <label for="homepage_latest_jobs_count" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Homepage Latest Jobs Count</label>
                                    <input type="number" name="homepage_latest_jobs_count" id="homepage_latest_jobs_count" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('homepage_latest_jobs_count') border-red-500 @enderror" value="{{ old('homepage_latest_jobs_count', $settings->homepage_latest_jobs_count) }}" min="0">
                                    @error('homepage_latest_jobs_count') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                            </div>
                        </section>

                    </div>
                    <div class="px-6 py-4 bg-gray-50 dark:bg-gray-700 text-right">
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">Save Settings</button>
                    </div>
                </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Add any JS needed for the settings page, e.g., image preview for file inputs
</script>
@endpush